package com.beiming.odr.referee.enums;

/**
 * @Auther: Administrator
 * @Date: 2019/6/5/005 14:21
 * @Description: 民族枚举
 */
public enum NationEnum {
  HAN("09_00005-1", "汉族"),
  MONGOLIAN("09_00005-2", "蒙古族"),
  HUI("09_00005-3", "回族"),
  ZANG("09_00005-4", "藏族"),
  UYGUR_ETHNIC("09_00005-5", "维吾尔族"),
  MIAO("09_00005-6", "苗族"),
  YI("09_00005-7", "彝族"),
  ZHUANG("09_00005-8", "壮族"),
  BUYI("09_00005-9", "布依族"),
  CHAOXIAN("09_00005-10", "朝鲜族"),
  MANCHU("09_00005-11", "满族"),
  DONG("09_00005-12", "侗族"),
  YAO("09_00005-13", "瑶族"),
  BAI("09_00005-14", "白族"),
  TUJIA("09_00005-15", "土家族"),
  HANI("09_00005-16", "哈尼族"),
  KAZAK("09_00005-17", "哈萨克族"),
  DAI("09_00005-18", "傣族"),
  LI("09_00005-19", "黎族"),
  LISU("09_00005-20", "傈僳族"),
  WA("09_00005-21", "佤族"),
  SHE_ETHNIC("09_00005-22", "畲族"),
  GAOSHAN("09_00005-23", "高山族"),
  LAHU("09_00005-24", "拉祜族"),
  SHUI("09_00005-25", "水族"),
  DONGXIANG("09_00005-26", "东乡族"),
  NAXI("09_00005-27", "纳西族"),
  JINGPO("09_00005-28", "景颇族"),
  KIRGIZ("09_00005-29", "柯尔克孜族"),
  TU("09_00005-30", "土族"),
  DAUR("09_00005-31", "达斡尔族"),
  MU("09_00005-32", "仫佬族"),
  QIANG("09_00005-33", "羌族"),
  BROWNIAN("09_00005-34", "布郎族"),
  SALAR("09_00005-35", "撒拉族"),
  MAO("09_00005-36", "毛难族"),
  GELO("09_00005-37", "仡佬族"),
  XIBO("09_00005-38", "锡伯族"),
  THE_CHANG("09_00005-39", "阿昌族"),
  PU_MEI("09_00005-40", "普米族"),
  TAJIK("09_00005-41", "塔吉克族"),
  NU("09_00005-42", "怒族"),
  UZBEK("09_00005-43", "乌孜别克族"),
  RUSSIANS("09_00005-44", "俄罗斯族"),
  EWHNKI("09_00005-45", "鄂温克族"),
  BENGLONG("09_00005-46", "崩龙族"),
  BAOAN("09_00005-47", "保安族"),
  YUGUR("09_00005-48", "裕固族"),
  JING("09_00005-49", "京族"),
  TATR("09_00005-50", "塔塔尔族"),
  DULONG("09_00005-51", "独龙族"),
  OROQEN("09_00005-52", "鄂伦春族"),
  HEZHEN("09_00005-53", "赫哲族"),
  MAMBA("09_00005-54", "门巴族"),
  LHOBA("09_00005-55", "珞巴族"),
  KINO("09_00005-56", "基诺族"),
  TAIWAN("09_00005-57", "台湾人"),
  HONGKONG("09_00005-58", "香港人"),
  MACAO("09_00005-59", "澳门人"),
  OVERSEAS_CHINESE("09_00005-60", "华侨"),
  OTHER("09_00005-255", "其他"),


      ;

  private String tdhCode;
  private String name;

  NationEnum(String code, String name) {
    this.tdhCode = code;
    this.name = name;
  }

  public static String getNation(String name) {
    String result = "";
    for (NationEnum nationEnum : NationEnum.values()) {
      if (nationEnum.getName().equals(name)) {
        result = nationEnum.toString();
      }
    }
    return result;
  }

  public static String getNationByCode(String code) {
    String result = "";
    for (NationEnum nationEnum : NationEnum.values()) {
      if (nationEnum.getTdhCode().equals(code)) {
        result = nationEnum.toString();
      }
    }
    return result;
  }

  public static NationEnum getNationEnumByCode(String code) {
    NationEnum result = null;
    for (NationEnum nationEnum : NationEnum.values()) {
      if (nationEnum.getTdhCode().equals(code)) {
        result = nationEnum;
      }
    }
    return result;
  }

  public String getName() {
    return name;
  }

  public String getTdhCode() {
    return tdhCode;
  }
}
