package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.calc.CalcYearsDetailsReqDTO;
import com.beiming.odr.referee.dto.requestdto.calc.CaseAuxiliaryToolsDTO;
import com.beiming.odr.referee.dto.requestdto.calc.EconomicCompensationReqDTO;
import com.beiming.odr.referee.dto.requestdto.calc.EmploymentInjuryInsuranceReqDTO;
import com.beiming.odr.referee.dto.requestdto.calc.HeatSubsidiesReqDTO;
import com.beiming.odr.referee.dto.requestdto.calc.InfringementDisputeReqDTO;
import com.beiming.odr.referee.dto.requestdto.calc.LoanContractReqDTO;
import com.beiming.odr.referee.dto.requestdto.calc.LoanContractResDTO;
import com.beiming.odr.referee.dto.requestdto.calc.NonOfficialDeathReqDTO;
import com.beiming.odr.referee.dto.requestdto.calc.OvertimePayReqDTO;
import com.beiming.odr.referee.dto.requestdto.calc.WorkCompensationReqDTO;
import com.beiming.odr.referee.dto.requestdto.calc.WorkDeadCompensationReqDTO;
import com.beiming.odr.referee.dto.requestdto.calc.WorkInjurySalaryReqDTO;
import com.beiming.odr.referee.dto.requestdto.calc.WorkSalaryReqDTO;
import com.beiming.odr.referee.dto.responsedto.calc.CalcAllowanceResDTO;
import com.beiming.odr.referee.dto.responsedto.calc.EmploymentInjuryInsuranceResDTO;
import com.beiming.odr.referee.dto.responsedto.calc.InfringementResDTO;
import com.beiming.odr.referee.dto.responsedto.calc.NonOfficialDeathResDTO;
import com.beiming.odr.referee.dto.responsedto.calc.WorkCompensationResDTO;
import com.beiming.odr.referee.dto.responsedto.calc.WorkDeadCompensationResDTO;
import com.beiming.odr.referee.dto.responsedto.calc.WorkInjurySalaryResDTO;

import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import javax.validation.Valid;

@Valid
public interface CalcApi {

  /**
   * 工伤赔偿
   *
   * @param dto
   * @return
   */
  DubboResult<WorkCompensationResDTO> getDisabledAllowance(WorkCompensationReqDTO dto);

  /**
   * 一次性工伤医疗补助金
   *
   * @param dto
   * @return
   */
  DubboResult<CalcAllowanceResDTO> getDisabledEmploymentAllowance(WorkCompensationReqDTO dto);

  /**
   * 工伤死亡赔偿
   *
   * @param dto
   * @return
   */
  DubboResult<WorkDeadCompensationResDTO> getDeadAllowance(WorkDeadCompensationReqDTO dto);

  /**
   * 非因公死亡补偿
   *
   * @param dto
   * @return
   */
  DubboResult<NonOfficialDeathResDTO> getNonOfficialDeathAllowance(NonOfficialDeathReqDTO dto);

  /**
   * 患病或非因工负伤
   *
   * @param dto
   * @return
   */
  DubboResult<WorkInjurySalaryResDTO> getWorkInjurySalaryAllowance(WorkInjurySalaryReqDTO dto);

  /**
   * 经济补偿金
   *
   * @param dto
   * @return
   */
  DubboResult<CalcAllowanceResDTO> getEconomicCompensationAllowance(EconomicCompensationReqDTO dto);

  /**
   * 高温补贴
   *
   * @param dto
   * @return
   */
  DubboResult<CalcAllowanceResDTO> getheatSubsidiesAllowance(HeatSubsidiesReqDTO dto);

  /**
   * 加班费
   *
   * @param dto
   * @return
   */
  DubboResult<CalcAllowanceResDTO> getOvertimePayAllowance(OvertimePayReqDTO dto);

  /**
   * 工伤保险-伤残待遇
   *
   * @param dto
   * @return
   */
  DubboResult<EmploymentInjuryInsuranceResDTO> getEmploymentInjuryInsurance(
      EmploymentInjuryInsuranceReqDTO dto);

  /**
   * 工伤保险伤亡待遇
   *
   * @param dto
   * @return
   */
  DubboResult<WorkDeadCompensationResDTO> getEmploymentInjuryDead(
      WorkDeadCompensationReqDTO dto);

  /**
   * 工资发放
   *
   * @param dto
   * @return
   */
  DubboResult<CalcAllowanceResDTO> getWorkSalary(
      WorkSalaryReqDTO dto);

  /**
   * 侵权纠纷类人身损害赔偿
   *
   * @param dto
   * @return
   */
  DubboResult<InfringementResDTO> getInfringementDispute(InfringementDisputeReqDTO dto);

  /**
   * 借款合同纠纷类利息
   *
   * @param dto
   * @return
   */
  DubboResult<LoanContractResDTO> getLoanContract(LoanContractReqDTO dto);
  /**
   * 保存历年基本数据
   */
  DubboResult<Integer> insertCaseAuxiliaryTools(CaseAuxiliaryToolsDTO caseAuxiliaryTools);

  /**
   * 查询历年基本数据
   */
  DubboResult<PageInfo<CaseAuxiliaryToolsDTO>> getList(Integer pageSize, Integer pageNum);

  /**
   * 查询当年基本数据
   */
  DubboResult<CaseAuxiliaryToolsDTO> getCaseAuxiliaryToolsByYear(Integer year);

  /**
   * 修改当年基本数据
   */
  DubboResult<Integer> updateCaseAuxiliaryTools(CaseAuxiliaryToolsDTO caseAuxiliaryTools);
  /**
   * 删除当年基本数据
   */
  DubboResult<Integer> delCaseAuxiliaryTools(Long key);
  /**
   * 获取可用的年
   */
  DubboResult<ArrayList<CalcYearsDetailsReqDTO>> getAllYear();
}
