package com.beiming.odr.referee.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Auther: Administrator
 * @Date: 2019/5/16/016 12:30
 * @Description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SuitLitigantDTO implements Serializable {

  private static final long serialVersionUID = 8504621773972440134L;
  //当事人序号,4位自增整数序号，从0001开始
  @JsonProperty("xh")
  private String number;
  //当事人类型
  @JsonProperty("lx")
  private String type;
  //诉讼地位
  @JsonProperty("ssdw")
  private String suitStatus;
  //当事人姓名/单位名称
  @JsonProperty("dsrxm")
  private String name;
  //联系电话,原告或申请人必填，其他诉讼地位非必填"
  @JsonProperty("lxdh")
  private String phone;
  //地址
  @JsonProperty("dz")
  private String address;
  //诉讼代理人名称，可有多个，多个之间用逗号分隔
  @JsonProperty("ssdlr")
  private String suitAgentNames;
  //诉讼代理人序号，可有多个，多个之间用逗号分隔
  @JsonProperty("ssdlrxh")
  private String suitAgentNums;
  //证件号码，原告或申请人必填，其他诉讼地位非必填
  @JsonProperty("zjhm")
  private String cardNum;
  //出生日期
  @JsonProperty("csrq")
  private String birthDate;
  //民族
  @JsonProperty("mz")
  private String nation;
  //性别
  @JsonProperty("xb")
  private String sex;
  //证件类型
  @JsonProperty("zjlx")
  private String certificateType;
  //邮政编码
  @JsonProperty("yzbm")
  private String postalCode;
  //国籍
  @JsonProperty("gj")
  private String nationality;
  //政治面貌
  @JsonProperty("zzmm")
  private String politicalStatus;
  //文化程度
  @JsonProperty("whcd")
  private String educationDegree;
  //年龄
  @JsonProperty("nianl")
  private String age;
  //职业
  @JsonProperty("zhiy")
  private String job;
  //法定代表人
  @JsonProperty("fddbr")
  private String legalRepresentative;
  //法定代表人证件种类，原告或申请人必填，其他诉讼地位非必填
  @JsonProperty("dbrzjzl")
  private String legalRepresentativeCertificateType;
  //法定代表人证件号码，原告或申请人必填，（当slfy LIKE ‘5101%’时非必填），其他诉讼地位非必填
  @JsonProperty("dbrzjhm")
  private String legalRepresentativeCardNum;
  //组织机构代码，原告或申请人必填，其他诉讼地位非必填
  @JsonProperty("zzjgdm")
  private String organizationalCode;


}
