package com.beiming.odr.referee.dto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import java.io.Serializable;
import lombok.Data;

/**
 * 监督预警案件列表对象
 *
 * @author liubao
 * @Date: 2024/06/26
 */
@Data
@EncryptDecryptData
public class SupervisionWarningCaseDTO implements Serializable {

  private static final long serialVersionUID = -7560047744833431002L;
  /**
   * 案件id
   */
  private Long id;

  /**
   * 调解类型（人民调解，行政调解
   */
  private String mediationType;

  /**
   * 案件编号
   */
  @EncryptDecryptField
  private String caseNo;

  /**
   * WAIT_HANDLE-处理中 WAIT_CONFIRM-待受理 WAIT_ASSGIN-待分配
   */
  private String lawCaseStatus;

  /**
   * 调解员id（案件承办人代码）
   */
  private String mediatorId;

  /**
   * 调解员名称（案件承办人）
   */
  private String mediatorName;

  /**
   * 调解开始时间
   */
  private String startTime;

  /**
   * 调解结束时间
   */
  private String endTime;

  /**
   * 创建时间（案件登记时间）
   */
  private String createTime;

  /**
   * 案件状态代码
   */
  private String ajztdm;

  /**
   * 案件状态名称
   */
  private String ajztmc;

  /**
   * 处理期限
   */
  private String deadLine;

  /**
   * 受理日期
   */
  private String acceptTime;

  /**
   * 处理时长，天数
   */
  private String processTime;

}
