package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;

/**
 * @Description: 批量获取案件通过UserId和Type返回类
 * @Author: dxy
 * @Date: Created 2018-08-30
 */
@Data
@ApiModel(value = "量获取案件通过UserId和Type返回类", description = "获取案件返回类")
@EncryptDecryptData
public class BigCasePersonResponseDTO implements Serializable {

  private static final long serialVersionUID = -2272366847237258550L;

  @ApiModelProperty(notes = "id",  example = "666")
  private String id;

  @ApiModelProperty(notes = "案件id", example = "575")
  private String lawcaseid;

  @ApiModelProperty(notes = "案件建立时间",  example = "2019-06-02 13:01:24")
  private String createtime;

  @ApiModelProperty(notes = "案件编号", example = "（2019）多元化解800号")
  @EncryptDecryptField
  private String caseno;

  @ApiModelProperty(notes = "案件状态",  example = "START")
  private String caseprogress;

  @ApiModelProperty(notes = "人员类型", example = "APPLICANT")
  private String caseusertype;

  @ApiModelProperty(notes = "人员姓名", example = "haha")
  private String username;



}
