package com.beiming.odr.referee.api;

import javax.validation.Valid;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.MediationDissentGetReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationDissentSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationDissentSendReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationDissentGetResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationDissentSaveResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationDissentSendResDTO;

/**
 * 异议书API
 * 
 * @author DJQ 2018年6月26日
 *
 */
@Valid
public interface MediationDocDissentApi {

  /**
   * 发送异议书
   * 
   * @return
   */
  DubboResult<MediationDissentSendResDTO> sendMediationDissent(
      @Valid MediationDissentSendReqDTO reqDTO);

  /**
   * 获取异议书
   * 
   * @return
   */
  DubboResult<MediationDissentGetResDTO> getMediationDissent(
      @Valid MediationDissentGetReqDTO reqDTO);

  /**
   * 保存异议书
   * 
   * @return
   */
  DubboResult<MediationDissentSaveResDTO> saveMediationDissent(
      @Valid MediationDissentSaveReqDTO reqDTO);

}
