package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.dto.CaseDispositionRecordDTO;
import com.beiming.odr.referee.dto.RecommendSolutionDTO;
import com.beiming.odr.referee.dto.requestdto.MediationListReqDTO;
import com.beiming.odr.referee.dto.requestdto.RecommendSolutionRequestDTO;
import com.beiming.odr.referee.dto.responsedto.MediationListResDTO;
import java.util.ArrayList;
import javax.validation.Valid;

/**
 * 调解信息扩展API
 *
 * @author xiaoying
 * @date 2022/05/17
 */
public interface MediationInfoExtendApi {

  /**
   * 案件调解列表
   *
   * @param reqDTO
   * @return
   */
  DubboResult<PageInfo<MediationListResDTO>> listMediationInfo(@Valid MediationListReqDTO reqDTO);

  DubboResult<RecommendSolutionDTO> getRecommendSolution(RecommendSolutionRequestDTO requestDTO);

  DubboResult<ArrayList<CaseDispositionRecordDTO>> getDispositionList(
      CaseDispositionRecordDTO reqDTO);

  DubboResult<CaseDispositionRecordDTO> getDispositionRecordDetail(
      CaseDispositionRecordDTO reqDTO);

  DubboResult<String> saveDispositionRecord(CaseDispositionRecordDTO reqDTO);

  DubboResult updateDispositionRecord(CaseDispositionRecordDTO reqDTO);

  DubboResult<String> getDetail(String id, Integer type);
}
