package com.beiming.odr.referee.dto;

import com.beiming.framework.page.PageQuery;
import java.io.Serializable;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 司法确认案件列表 请求参数
 *
 * @author xiaoying
 * @date 2022/03/02
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class JudicialListReqDTO extends PageQuery implements Serializable {

  private static final long serialVersionUID = -2326143176608490189L;

  /**
   * 用户ID
   */
  private Long userId;

  /**
   * 关键词 编号、姓名、案号
   */
  private String keyWord;

  /**
   * 案件状态
   */
  private List<String> lawCaseStatus;

  /**
   * 组织区域
   */
  private List<Long> orgIds;

  /**
   * 查询的数据类型
   * ASSIGN 待分配
   * ASSIGNED 已分配
   * AUDIT 待审核
   * AUDITED 已审核
   */
  private String dataType;
}
