package com.beiming.odr.referee.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class MediationCaseAgentPersonnelBriefDTO implements Serializable {

  private static final long serialVersionUID = 5946545033240232723L;

  /**
   * 用户类型（一般代理人、特权代理人）
   */
  private String agentType;

  /**
   * 代理人名称
   */
  private String agentName;

  /**
   * 性别
   */
  private String sex;

  /**
   * 联系电话
   */
  private String phone;

  /**
   * 国籍
   */
  private String nationality;

  /**
   * 民族
   */
  private String nation;

  /**
   * 证件类型
   */
  private String cardType;

  /**
   * 证件号码（如身份证）
   */
  private String idCard;

  /**
   * 详细地址
   */
  private String address;

  private String defenseType;

}
