package com.beiming.odr.referee.dto;

import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * @author jiangfan
 * @date 2025/09/01
 */
@Data
public class TurnArbitrationPersonalsDTO implements Serializable {

  /**
   * 法院当事人唯一标识(ID)
   */
  private Long id;

  /**
   * 仲裁当事人唯一标识(ID)（和法院id一一对应）
   */
  private Integer arbitrateId;

  /**
   * 见字典：人员类型
   */
  private Integer userType;

  /**
   * 见字典：人员类型
   */
  private Integer clientType;

  /**
   * 姓名/公司名称
   */
  private String userName;

  /**
   * 性别
   */
  private Integer sex;

  /**
   * 年龄
   */
  private Integer age;

  /**
   * 手机号码
   */
  private String phone;

  /**
   * 证据类型
   */
  private String identificationType;

  /**
   * 身份证号码(证据类型为身份证时)
   */
  private String identification;

  /**
   * 统一社会信用代码
   */
  private String creditCode;

  /**
   * 军官证
   */
  private String officerNo;

  /**
   * 护照
   */
  private String passportNo;

  /**
   *法定代表人
   */
  private String legalPerson;

  /**
   * 法定地址
   */
  private String address1;

  /**
   * 居住地址/注册地址
   */
  private String address2;

  /**
   * 其他地址
   */
  private String address3;

  private List<TurnArbitrationAgentsDTO> agents;

}
