package com.beiming.odr.referee.dto.requestdto;

import com.beiming.framework.page.PageQuery;
import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 立案列表查询
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EncryptDecryptData
public class CaseReportReqDTO extends PageQuery implements Serializable {

  private static final long serialVersionUID = 1L;
  private String startTime; //开始时间
  private String endTime; //结束时间
  @EncryptDecryptField
  private String caseNo; //案号
  private String caseProgress;
  private String dayTime; //天

}
