package com.beiming.odr.referee.dto.responsedto;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 案件人员-代理人-数据响应DTO
 * @author xiaoying
 * @date 2021/12/10
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CasePersonAngelResDTO implements Serializable {

  private static final long serialVersionUID = -7719004967037558229L;

  @ApiModelProperty(notes = "主键Id", example = "666")
  private Long id;

  @ApiModelProperty(notes = "案件id", example = "666")
  private Long lawCaseId;

  @ApiModelProperty(notes = "当事人id", example = "666")
  private Long applyPartyId;

  @ApiModelProperty(notes = "代理人名称", example = "666")
  private String agentName;

  @ApiModelProperty(notes = "代理人证件类型", example = "666")
  private String cardType;

  @ApiModelProperty(notes = "代理人证件号码", example = "666")
  private String idCard;

  @ApiModelProperty(notes = "代理人手机号码", example = "666")
  private String phone;

  @ApiModelProperty(notes = "代理人律师执业证", example = "666")
  private String lawyerCardNum;

}