package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * 导入案件列表接口
 * 
 * @author qsh
 *
 * @2019年3月1日
 */
@Data
public class LawCaseImportListResDTO implements Serializable {


  private static final long serialVersionUID = 1L;

  private Long id;
  private Long lawCaseId;

  /**
   * 原编号
   */
  private String originalCaseNo;


  /**
   * 登记人
   */
  private String registrant;


  /**
   * 登记时间
   */
  private String registrantTime;

  /**
   * 处理机构
   */
  private String processingOrgName;


  /**
   * 模板大类目录
   */
  private String categoryDirectory;

  /**
   * 模板枚举
   */
  private String templateEnum;

  /**
   * 案件信息
   */
  LawCaseResDTO lawCaseResDTO;
  /**
   * 案件人员信息
   */
  List<CasePersonResDTO> casePersonResList;

}
