package com.beiming.odr.referee.dto.responsedto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.metadata.BaseRowModel;
import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import lombok.Data;

import java.io.Serializable;

@Data
@EncryptDecryptData
public class ReportFormResDTO extends BaseRowModel implements Serializable {

  private Long caseId;
  @ExcelProperty(value = "机构名称", index = 0)
  private String orgName;

  @ExcelProperty(value = "案件合计", index = 1)
  private Integer caseTotal;

  @ExcelProperty(value = "已完成案件", index = 2)
  private Integer caseByFinish;

  @ExcelProperty(value = "调解成功数", index = 3)
  private Integer caseBySuccess;

  @ExcelProperty(value = "调解成功率", index = 4)
  private String caseBySuccessRate;

  @ExcelProperty(value = "司法确认", index = 5)
  private Integer caseByConfirm;

  @ExcelProperty(value = "预约视频调解数", index = 6)
  private Integer orderMeeting;

  @ExcelProperty(value = "线上发送文书数", index = 7)
  private Integer sendDocumentOnline;

  @ExcelProperty(value = "在线立案数", index = 8)
  private Integer registerOnline;

  private Long orgId;

  private Long mediatorId;

  private String mediatorName;

  private String orgType;

  @EncryptDecryptField
  private String caseNo;

  private String caseProgress;

  private String createTime;

  private String endTime;

  private String laTimeOnline;

  private String sfConfirmTime;
}
