package com.beiming.odr.referee.dto.responsedto.haoda;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 网上立案和司法确认案件详情中当事人的代理人信息
 *
 * @author xiaoying
 * @date 2022/01/17
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CaseUserAgentDetailDTO implements Serializable {

  private static final long serialVersionUID = -7719004967037558229L;

  /**
   * 代理人类型 平台专用 APPLICANT 申请人 RESPONDENT 被申请人
   */
  private String agentType;

  /**
   * 代理人姓名
   */
  private String name;

  /**
   * 代理人证件类型 平台自身使用
   */
  private String cardType;

  /**
   * 代理人证件号码
   */
  private String idCard;

  /**
   * 代理人手机号码
   */
  private String phone;

  /**
   * 代理人律师执业证
   */
  private String certificate;

  /**
   * 代理人性别
   */
  private String sex;

  /**
   * 国籍
   */
  private String nationality;

  /**
   * law_case_agent_personnel数据表主键
   */
  private Long id;
}