package com.beiming.odr.referee.enums;

/**
 * @Author: JACHE
 */
public enum OdrCaseTypeEnum {
  COURT(1, "法院引调案"),
  FINANCIAL_CASE(2, "金融类案"),
  INTELLECTUAL_PROPERTY_CASE(3, "知识产权类案"),
  SPECIAL_USER(4, "专项用户"),
  DIGITAL_GUANG_DONG(5, "数广"),
  COMMON_CASE(6, "普通");
  private Integer code;
  private String name;

  OdrCaseTypeEnum(Integer code, String name) {
    this.code = code;
    this.name = name;
  }

  public static String getNameByCode(Integer caseType) {
    OdrCaseTypeEnum[] values = OdrCaseTypeEnum.values();
    for (OdrCaseTypeEnum v : values) {
      if (v.getCode().equals(caseType)) return v.name();
    }
    return COMMON_CASE.name();
  }
  public static String getNameByEn(String caseType) {
    OdrCaseTypeEnum[] values = OdrCaseTypeEnum.values();
    for (OdrCaseTypeEnum v : values) {
      if (v.name().equals(caseType)) return v.name();
    }
    return COMMON_CASE.name();
  }

  public static OdrCaseTypeEnum getEnumByEn(String caseType) {
    OdrCaseTypeEnum[] values = OdrCaseTypeEnum.values();
    for (OdrCaseTypeEnum v : values) {
      if (v.name().equals(caseType)) return v;
    }
    return COMMON_CASE;
  }

  public static OdrCaseTypeEnum getEnumByCode(Integer caseType) {
    OdrCaseTypeEnum[] values = OdrCaseTypeEnum.values();
    for (OdrCaseTypeEnum v : values) {
      if (v.getCode().equals(caseType)) return v;
    }
    return COMMON_CASE;
  }

  public String getName() {
    return name;
  }

  public Integer getCode() {
    return code;
  }
}
