/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.referee.enums;

import com.google.common.collect.Lists;
import java.util.List;

public enum DocumentTypeEnum {
    MEDIATION_BOOK("\u8c03\u89e3\u534f\u8bae\u4e66"),
    COMMITMENT_BOOK("\u627f\u8bfa\u4e66"),
    NO_DISSENT_MEDIATION_SCHEME("\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848"),
    UNDISPUTED_FACT("\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4\u534f\u8bae"),
    MEDIATION_RECORD("\u8c03\u89e3\u7b14\u5f55"),
    INQUIRE_RECORD("\u8c03\u67e5\u7b14\u5f55"),
    DISSENT_RECORD("\u5f02\u8bae\u4e66"),
    LAW_TERMINATED_PROGRESS("\u6b63\u5e38\u7ec8\u7ed3\u6848\u4ef6\u8c03\u89e3\u8fdb\u5ea6"),
    JUDICIAL_CONFIRM_APPLY_BOOK("\u53f8\u6cd5\u786e\u8ba4\u7533\u8bf7\u4e66"),
    FINAL_MEDIATION_REPORT("\u7ec8\u7ed3\u8c03\u89e3\u62a5\u544a"),
    MEDIATION_APPLY_BOOK("\u8bf7\u6c42\u6cd5\u9662\u51fa\u5177\u8c03\u89e3\u4e66"),
    RECONCILIATION_AGREEMENT("\u8c03\u89e3\u4e66"),
    WITHDRAW_CASE("\u64a4\u56de\u7acb\u6848"),
    JUDICIAL_CONFIRM_BOOK("\u53f8\u6cd5\u786e\u8ba4\u4e66"),
    CLOSE_CASE_BOOK("\u8bc9\u4e2d\u7ed3\u6848\u6587\u4e66"),
    COMPRM_SETTLEMENT("\u548c\u89e3\u901a\u77e5\u4e66"),
    REMINDER_LETTER("\u50ac\u544a\u901a\u77e5\u4e66"),
    ADDRESS_CONFIRMATION("\u5730\u5740\u786e\u8ba4\u4e66"),
    APPLICATION_MEDIATION("\u8c03\u89e3\u7533\u8bf7\u4e66"),
    MEDIATION_ACCEPT_FORM("\u8c03\u89e3\u53d7\u7406\u767b\u8bb0\u8868"),
    CUSTOM_INSTRUMENTS("\u81ea\u5b9a\u4e49\u6587\u4e66");

    private String name;

    private DocumentTypeEnum(String name) {
        this.name = name;
    }

    public static DocumentTypeEnum getDocumentTypeByName(String value) {
        for (DocumentTypeEnum constant : DocumentTypeEnum.values()) {
            if (!constant.name().equals(value)) continue;
            return constant;
        }
        return null;
    }

    public static Boolean isJudicial(String documentType) {
        return JUDICIAL_CONFIRM_APPLY_BOOK.name().equals(documentType);
    }

    public static Boolean isRecord(String documentType) {
        return MEDIATION_RECORD.name().equalsIgnoreCase(documentType) || INQUIRE_RECORD.name().equalsIgnoreCase(documentType);
    }

    public static Boolean isPartyFistSign(String documentType) {
        return ADDRESS_CONFIRMATION.name().equalsIgnoreCase(documentType) || APPLICATION_MEDIATION.name().equalsIgnoreCase(documentType);
    }

    public static Boolean needMediatorInfo(DocumentTypeEnum documentType) {
        return !MEDIATION_RECORD.equals((Object)documentType) && !INQUIRE_RECORD.equals((Object)documentType) && !DISSENT_RECORD.equals((Object)documentType) && !APPLICATION_MEDIATION.equals((Object)documentType);
    }

    public static boolean noNeedSign(DocumentTypeEnum documentType) {
        return FINAL_MEDIATION_REPORT.equals((Object)documentType);
    }

    public static boolean onlyApplicantSign(DocumentTypeEnum documentType) {
        return APPLICATION_MEDIATION.equals((Object)documentType) || MEDIATION_ACCEPT_FORM.equals((Object)documentType);
    }

    public static boolean onlyMediatorSign(DocumentTypeEnum documentType) {
        return MEDIATION_APPLY_BOOK.equals((Object)documentType);
    }

    public static boolean isSaveAndSend(DocumentTypeEnum documentType) {
        return APPLICATION_MEDIATION.equals((Object)documentType);
    }

    public String getName() {
        return this.name;
    }

    public static List<DocumentTypeEnum> getCaseEndDoc() {
        return Lists.newArrayList((Object[])new DocumentTypeEnum[]{JUDICIAL_CONFIRM_APPLY_BOOK, MEDIATION_APPLY_BOOK});
    }

    public static Boolean isHtmlBook(DocumentTypeEnum documentType) {
        return CUSTOM_INSTRUMENTS.equals((Object)documentType);
    }
}

