package com.beiming.odr.referee.api.haoda;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.haoda.JudicialConfirmHistoryDTO;
import java.util.ArrayList;

/**
 * 司法确认历史记录api接口
 * @author xiaoying
 * @date 2021/12/24
 */
public interface JudicialConfirmHistoryApi {

  /**
   * 新增司法确认历史记录
   * @param dto
   * @return
   */
  DubboResult<Long> addJudicialConfirmHistory(JudicialConfirmHistoryDTO dto);

  /**
   * 根据id修改司法确认历史记录
   * 主要修改 result hdResponseTime值
   * @param dto
   */
  void editJudicialConfirmHistoryById(JudicialConfirmHistoryDTO dto);


  /**
   * 查询所有司法确认历史记录
   * @param dto
   * @return
   */
  DubboResult<ArrayList<JudicialConfirmHistoryDTO>> findAll(JudicialConfirmHistoryDTO dto);

  /**
   * 根据案件查询昊达查询号
   * @param caseId
   * @return
   */
  String findQueryNoByCaseId(String caseId);

}