package com.beiming.odr.referee.dto;

import lombok.Data;

/**
 * @author jiangfan
 * @date 2025/09/02
 */
@Data
public class LawAttachmentFileContent {

  private static final long serialVersionUID = -79748468548640386L;


  private Long id;

  /**
   * 文件名
   */
  private String fileName;

  /**
   * 文件内容
   */
  private String fileContent;

  /**
   * 文件fileid
   */
  private String fileId;


  /**
   * 附件大分类( 调解用，诉讼用，司法确认用等)
   */
  private String categoryBig;

  /**
   * 附件中分类(书证、物证、等等)
   */
  private String categoryMiddle;

  /**
   * 附件小分类(备用)
   */
  private String categorySmall;

  /**
   * 类型
   */
  private String objectType;


  /**
   * 当类型为书证时,sign为详细小分类0默认附件 1调谐协议书;2 调解笔录;3调查笔录;4司法确认申请书;5调解申请书;6当事人权利义务告知书;7授权委托书;8调解协议履行证明;9调解回访记录;10结案表;
   */
  private String sign;


  /**
   * 证据名称
   */
  private String evidenceName;

  /**
   * 证据来源
   */
  private String evidenceSource;

  /**
   * 证据数量
   */
  private Integer evidenceNum;

  /**
   * 证据目的
   */
  private String evidenceObjective;


  private Long fileInfoId;

}
