package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.dto.FileDTO;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 生成电子卷宗之前上传多个文件
 * 
 * @author chenjt
 * @data 2018年8月22日
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BatchFilesReqDTO implements Serializable {

  private static final long serialVersionUID = 4772247537899586575L;
  @NotNull(message = "{case.id.cannot.be.empty}")
  private Long caseId;

  @NotNull(message = "{file.cannot.be.empty}")
  @Size(message = "{file.cannot.be.empty}", min = 1)
  private List<FileDTO> files;
  
//  @NotNull(message = "{signature.cannot.be.empty}")
  private String sign;
  @NotNull(message = "{user.id.cannot.be.empty}")
  private Long userId;
  private String categoryMiddle;
  private String userName;
  private String objectType; // 类型
  private String categoryBig;
  private String previewUrl;
  private Long meetingId; // 会议id
  private String fileType; // 材料类型
  private String permitUserIds; // 允许访问当前文件的用户ID数组(JSON格式)
  //证据名称
  private String evidenceName;

  //证据数量
  private Integer evidenceNum;

  //证据目的
  private String evidenceObjective;

  //证据来源
  private String evidenceSource;
}
