package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.constant.RefereeValidateMessage;
import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by zli on 2019/1/28.
 *
 * 案件id
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CaseIdReqDTO implements Serializable {

  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  @Min(value = 1, message = "值非法")
  private Long caseId;

  /**
   * 会议类型
   */
  private String mediationMeetingType;

  public CaseIdReqDTO(Long caseId) {
    this.caseId = caseId;
  }
}
