/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.referee.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class MsgUtils {
    private static MessageSource messageSource;

    public MsgUtils(MessageSource messageSource) {
        MsgUtils.messageSource = messageSource;
    }

    public static String get(String msgKey, String ... args) {
        try {
            return messageSource.getMessage(msgKey, (Object[])args, LocaleContextHolder.getLocale());
        }
        catch (Exception e) {
            return msgKey;
        }
    }

    public static String translateCaseNo(String caseNo) {
        return MsgUtils.translateCaseNo(caseNo, LocaleContextHolder.getLocale().toString());
    }

    public static String translateCaseNo(String caseNo, String locale) {
        String localeCaseNo;
        if (caseNo == null || "".equals(caseNo)) {
            return caseNo;
        }
        if (caseNo.contains("\u591a\u5143\u5316\u89e3")) {
            localeCaseNo = MsgUtils.getLocaleCaseNo(locale);
        } else if (caseNo.contains("\u8bc9\u524d\u6c11\u8c03")) {
            localeCaseNo = MsgUtils.getLocaleCaseNoBySQMT(locale);
        } else if (caseNo.contains("\u6c11\u8bc9\u524d\u8c03")) {
            localeCaseNo = MsgUtils.getLocaleCaseNoByMSQT(locale);
        } else {
            return caseNo;
        }
        return MsgUtils.replaceCaseNo(caseNo, localeCaseNo);
    }

    private static String getLocaleCaseNoByMSQT(String locale) {
        String localeCaseNo = "\uff08#year#\uff09\u7ca4#no#\u6c11\u8bc9\u524d\u8c03#num#\u53f7";
        if ("en_US".equalsIgnoreCase(locale)) {
            localeCaseNo = "(#year#) Yue #no# pre-litigation mediation #num#";
        } else if ("zh_TW".equalsIgnoreCase(locale)) {
            localeCaseNo = "\uff08#year#\uff09\u7cb5#no#\u6c11\u8a34\u524d\u8abf#num#\u865f";
        }
        return localeCaseNo;
    }

    private static String replaceCaseNo(String caseNo, String localeCaseNo) {
        String regEx = "[^0-9]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(caseNo);
        String nums = m.replaceAll(" ").trim();
        nums = nums.replaceAll(" +", " ");
        String[] numArr = nums.split(" ");
        switch (numArr.length) {
            case 2: {
                localeCaseNo = localeCaseNo.replace("#year#", numArr[0]).replace("#num#", numArr[1]);
                break;
            }
            case 3: {
                localeCaseNo = localeCaseNo.replace("#year#", numArr[0]).replace("#no#", numArr[1]).replace("#num#", numArr[2]);
                break;
            }
        }
        return localeCaseNo;
    }

    private static String getLocaleCaseNo(String locale) {
        String localeCaseNo = "\uff08#year#\uff09\u591a\u5143\u5316\u89e3#num#\u53f7";
        if ("en_US".equalsIgnoreCase(locale)) {
            localeCaseNo = "(#year#) Diversified Resolution #num#";
        } else if ("zh_TW".equalsIgnoreCase(locale)) {
            localeCaseNo = "\uff08#year#\uff09\u591a\u5143\u5316\u89e3#num#\u865f";
        }
        return localeCaseNo;
    }

    private static String getLocaleCaseNoBySQMT(String locale) {
        String localeCaseNo = "\uff08#year#\uff09\u7ca4#no#\u8bc9\u524d\u6c11\u8c03#num#\u53f7";
        if ("en_US".equalsIgnoreCase(locale)) {
            localeCaseNo = "(#year#) Yue #no# pre-litigation mediation #num#";
        } else if ("zh_TW".equalsIgnoreCase(locale)) {
            localeCaseNo = "\uff08#year#\uff09\u7cb5#no#\u8a34\u524d\u6c11\u8abf#num#\u865f";
        }
        return localeCaseNo;
    }

    private static String getLocaleCaseNoMC(String locale) {
        String localeCaseNo = "\uff08#year#\uff09\u7ca4#no#\u6c11\u521d#num#\u53f7";
        if ("en_US".equalsIgnoreCase(locale)) {
            localeCaseNo = "(#year#) Yue #no# civil first instance #num#";
        } else if ("zh_TW".equalsIgnoreCase(locale)) {
            localeCaseNo = "\uff08#year#\uff09\u7cb5#no#\u6c11\u521d#num#\u865f";
        }
        return localeCaseNo;
    }
}

