package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.*;
import com.beiming.odr.referee.dto.responsedto.*;
import com.beiming.odr.referee.enums.SMSCodeEnum;
import com.beiming.odr.user.api.dto.responsedto.ReportCommonDTO;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public interface LawCaseApi {

  void updateApprovalType(Long lawCaseId, String updateUser, Integer approvalType,
      Long auditId);

  DubboResult<String> copyCase(Long lawCaseId, Integer num, Long sequence);

  void updateIsFailAutoFilingFlag(Long mediateSeq);

  List<LawCaseResponseDTO> getByLawCaseStatus(String status, Date startTime, Date endTime);

  List<RemindInfoResDTO> getRemindInfoList(SMSCodeEnum smsCodeEnum, Date limitTime);

  DubboResult addFollowPerson(AddFollowPersonReqDTO addFollowPersonReqDTO);

  LawCaseResponseDTO getLawCase(long lawcaseId);

  List<LawCaseResDTO> listLawCaseByIds(Set<Long> lawCaseIds);

  void updateCaseStatus(Long lawCaseId, String caseStatus);

  LawCaseResDTO getLawCaseByCaseNo(String caseNo);

  /**
   * 更新案件人员信息
   *
   * @param reqDTO
   * @param caseId
   * @return
   */
  DubboResult<Integer> updateLawCasePerson(MediationCaseReqDTO reqDTO, Long caseId);

  /**
   * 根据案件id更新案件的纠纷类型 创建时间
   *
   * @param caseId          案件id
   * @param disputeTypeCode 纠纷类型code
   * @param disputeType     纠纷类型名称
   * @param createTime      创建时间
   * @return
   */
  DubboResult<Integer> updateLawCase(Long caseId, String disputeTypeCode, String disputeType, Date createTime);

  /**
   * 保存公安驻所案件材料
   */
  DubboResult savePoliceAttachment(List<IntranetAttachmentReqDTO> attachmentList, Long caseId);

  List<LawCaseCountDownResDTO> listCase3DaysCountDown();

  /**
   * 作废案件
   */
  DubboResult<Integer> abolishCase(Long caseId);

  /**
   * 撤回作废案件
   */
  DubboResult<Integer> revokeAbolishCase(Long caseId);

  /**
   * 删除案件
   */
  DubboResult<Integer> deleteCaseById(Long caseId);
  /**
   * 修改案件信息。
   */
  DubboResult<Integer> updateCaseInfo(MediationCaseReqDTO req, Long caseId);

  /**
   * 终止回访
   */
  DubboResult<Integer> terminateCaseVisit(Long caseId);

  /**
   * 查询调解员调解数量接口
   */
  DubboResult<StaffCaseNumberResDTO> queryStaffNum(StaffCaseNumberReqDTO requestDTO);

  /**
   * 日程里查关联案件
   * @param userId
   * @return
   */
  DubboResult<ScheduleCaseDTO> getCaseByUserId(String userId);

  /**
   * 工作台案件统计
   * @param
   * @return
   */
  DubboResult<ArrayList<ReportCommonDTO>> caseTotal(ArrayList<MediationListReqDTO> dtos, String userId);

  /**
   * 绩效看板
   * @param userId
   * @return
   */
  DubboResult<ArrayList<ReportCommonDTO>> dashboard(String userId, ArrayList<MediationListReqDTO> listReqDTOS);

}
