package com.beiming.odr.referee.api.haoda;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.haoda.CaseAssignReqDTO;
import com.beiming.odr.referee.dto.requestdto.haoda.CaseCheckReqDTO;
import com.beiming.odr.referee.dto.requestdto.haoda.CheckDetailReqDTO;
import com.beiming.odr.referee.dto.responsedto.haoda.CaseTypeResDTO;
import com.beiming.odr.referee.dto.responsedto.haoda.CourtAreasResDTO;
import com.beiming.odr.referee.dto.responsedto.haoda.CourtResDTO;
import com.beiming.odr.referee.dto.responsedto.haoda.HdDisputeCodeResDTO;
import com.beiming.odr.referee.dto.responsedto.haoda.LawCaseCheckDTO;
import java.util.ArrayList;

/**
 * 昊达数据拉取api接口
 *
 * @author xiaoying
 * @date 2021/12/07
 */
public interface HaoDaPullExtendApi {

  /**
   * 根据法院Id查询对应的街道
   *
   * @param courId
   * @return
   */
  DubboResult<ArrayList<CourtAreasResDTO>> findByCourtId(String courId);

  /**
   * 根据区域Id查询对应的法院
   *
   * @param areasId
   * @return
   */
  DubboResult<CourtAreasResDTO> findByAreasId(String areasId);

  /**
   * 存储案件司法确认审核案件信息
   *
   * @param dto
   * @return
   */
  DubboResult<Boolean> saveLawCaseCheckDetail(CheckDetailReqDTO dto);

  /**
   * 司法确认案件 分配审核员
   *
   * @param dto
   * @return
   */
  DubboResult<Boolean> assignLawCaseCheckDetail(CaseAssignReqDTO dto);

  /**
   * 获取昊达  案件类型数据
   *
   * @return
   */
  DubboResult<ArrayList<CaseTypeResDTO>> getCaseTypeList();

  /**
   * 根据法院code获取法院信息
   *
   * @param code
   * @return
   */
  DubboResult<CourtResDTO> getCourtByCode(String code);

  /**
   * 根据code值查询民事案由数据
   *
   * @param code
   * @return
   */
  DubboResult<HdDisputeCodeResDTO> findByCode(String code);


  /**
   * 存储案件司法确认审核案件信息
   *
   * @param dto
   * @return
   */
  DubboResult<Boolean> checkLawCaseCheckDetail(CaseCheckReqDTO dto);

  /**
   * 根据id获取司法确认案件信息
   *
   * @param lawCaseId
   * @return
   */
  DubboResult<LawCaseCheckDTO> getLawCaseCheck(Long lawCaseId);

  /**
   * 根据用户id查询 当前审核员正在审核的案件数
   *
   * @param userId
   * @return
   */
  DubboResult<Integer> countLawCaseCheckByUserId(Long userId);

  /**
   * 根据id查询涉及案件类型的code值
   *
   * @param id
   * @return
   */
  DubboResult<String> getCaseTypeCodeById(Long id);

  /**
   * 根据code查询案件类型对象
   *
   * @param code
   * @return
   */
  DubboResult<CaseTypeResDTO> findCaseTypeByCode(String code);

}