package com.beiming.odr.referee.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Auther: XZY
 * @Date: 2019/1/22/022 14:07
 * @Description: 通达海调解当事人推送实体
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonInclude(value = Include.NON_NULL)
public class CaseUserTdhDTO implements Serializable {


  private static final long serialVersionUID = 6230503728842285486L;

  @NotNull(message = "{party.id.cannot.be.empty}")
  @JsonProperty("dsrxh")
  private String citeUserId; //当事人ID
  @NotNull(message = "{change.type.cannot.be.empty}")
  @JsonProperty("dsrzt")
  private String mode;  //增删改
  @NotNull(message = "{the.name.of.the.party.cannot.be.empty}")
  @JsonProperty("dsrmc")
  private String userName;  //当事人姓名
  @NotNull(message = "{litigation.status.cannot.be.empty}")
  @JsonProperty("ssdw")
  private String caseUserType;  //"诉讼地位（ 原告被告）"
  @NotNull(message = "{party.type.cannot.be.empty}")
  @JsonProperty("dsrlx")
  private String userType;  //当事人类型（ 自然人， 法人， 非法人组织）

  //下列数据项当事人类型为自然人（15_000004-1）时填写
  @JsonProperty("sjhm")
  private String phone;  //手机号
  @JsonProperty("xb")
  private String sex;  //性别
  @JsonProperty("csrq")
  private String birthDate;  //出生年月
  @JsonProperty("nl")
  private String age;  //年龄
  @JsonProperty("mz")
  private String ethnicity;  //民族
  @JsonProperty("zy")
  private String job;  //职业
  @JsonProperty("zjxxlist")
  private List<TdhCardTypeDTO> cardList;  //证件类型
  @JsonProperty("gj")
  private String nationality = "15_GB0006-44"; //国籍 写死中国
  @JsonProperty("dz")
  @NotNull
  private String address;   //地址
  @JsonProperty("sddz")
  private String mailAddress; //送达地址
  //下列数据项当事人类型为非自然人（<>15_000004-1）时填写
  private String gbhdq = "15_GB0006-44"; //注册登记地国别
  @JsonProperty("zzjgdm")
  private String creditCode;  //组织机构
  @JsonProperty("fddbr")
  private String corporation; //法定代表人
  @JsonProperty("dbrzjhm")
  private String corporationCardNum; //代表人证件号码
  @JsonProperty("dwdz")
  private String workAddress; //工作单位


  //通达海证件列表实体
  @Data
  @AllArgsConstructor
  class TdhCardTypeDTO {

    @JsonProperty("zjzl")
    private String cardNum; //证件号码
    @JsonProperty("zjhm")
    private String cardType; //证件类型
  }

}
