package com.beiming.odr.referee.dto.requestdto.shewai;


import com.beiming.odr.referee.enums.CaseProgressEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 *
 * @author yi.liu
 */
@Data
public class LawCaseDTO implements Serializable {

  /**
   * 调解类型（人民调解，行政调解)
   */
  private String mediationType;

  /**
   * 案件录入人id
   */
  private Long creatorId;

  /**
   * 案件录入人的身份
   */
  private String creatorType;

  /**
   * 案件编号
   */
  private String caseNo;

  /**
   * 视频表id
   */
  private Long videoId;

  /**
   * 状态码(05纠纷被拒绝受理等)
   */
  private String lawCaseStatus;

  /**
   * 案件进度
   */
  private CaseProgressEnum caseProgress;

  /**
   * 咨询纠纷id，咨询转立案存入该值
   */
  private Long disputesId;

  /**
   * 纠纷类型字典表code
   */
  private String disputeTypeCode;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 省份code
   */
  private String provCode;

  /**
   * 城市code
   */
  private String cityCode;

  /**
   * 区code
   */
  private String areaCode;

  /**
   * 街道code
   */
  private String streetCode;

  /**
   * 省份名称
   */
  private String provName;

  /**
   * 城市名称
   */
  private String cityName;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 社区code
   */
  private String communityCode;

  /**
   * 社区名称
   */
  private String communityName;

  /**
   * 详细地址
   */
  private String address;

  /**
   * 机构id
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 机构地区code
   */
  private String orgAreaCode;

  /**
   * 调解员id
   */
  private Long mediatorId;

  /**
   * 调解员名称
   */
  private String mediatorName;

  /**
   * 案件来源。本平台录入； 第三方平台导入。网上立案系统导入，律师平台导入
   */
  private String origin;

  /**
   * 机构业务负责人是否已经确认的字段(0：未确认 1：已确认)
   */
  private Boolean orgConfirm;

  /**
   * 调解开始时间
   */
  private Date startTime;

  /**
   * 调解结束时间
   */
  private Date endTime;

  /**
   * 案件完成时间
   */
  private Date caseCompleteTime;

  /**
   * 重新分配的标签
   */
  private String tab;

  /**
   * 选择性短信发送功能 0为发送，1为不发送
   */
  private Boolean smsOff;

  /**
   * 申请人诉求
   */
  private String appeal;

  /**
   * 纠纷描述
   */
  private String disputeContent;

  /**
   * 重新分配的详细内容
   */
  private String tabDetail;

  /**
   * 调解时间延长状态
   */

  private String extendStatus;

  /**
   * 调解时间延长确认状态
   */

  private String confirmStatus;
  /**
   * 调解时间延长天数
   */

  private Integer extendDay;
  /**
   * 延期原因
   */

  private String extendReason;
  /**
   * 调解期限
   */
  private Date mediationDeadline;
  /**
   * 延期表id
   */

  private Long extendId;


  /**
   * 是否终止过案件
   */
  private Boolean isSuspend;

  private Integer suspendNum;

  /**
   * 引调案件Id
   */
  private String citeCaseId;

  /**
   * 国家名称
   */
  private String nationName;

  /**
   * 国家code
   */
  private String nationCode;

  /**
   * 引调案件号
   */
  private String citeCaseName;

  private String citeCaseType;

  private String citeCaseFilingSeq;

  /**
   * 增加案件撤回状态返回
   * 空为 未发起申请
   * AUDIT_RETRACT_CANCEL_CASE  发起申请状态
   * AUDIT_RETRACT_CANCEL_CASE_SUCCESS  审核通过
   * AUDIT_RETRACT_CANCEL_CASE_FAIL  审核不通过
   */
  private String cancelAudit;

  //国商caseId
  private String gsCaseId;
  //国商caseNo
  private String gsCaseNo;
  private Long id;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 版本号
   */
  private Integer version;

  /**
   * 状态 0 正常 1 删除
   */
  private Integer status;

  /**
   * 备注
   */
  private String remark;
}
