package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@EncryptDecryptData
public class CaseInfoCollectResDTO implements Serializable {

  private String mediationId;

  private Integer courtCode; //法院代码

  @EncryptDecryptField
  private String caseNo; //案号

  private Date caseApplyDate;

  private Integer state;

  private Integer result; //调解结果

  private String caseType;  //案件类型

  private Integer type; //调解类型 0互联网调解   1诉前调解    2诉中调解

  private Date applyDate;

  private Date endDate;

  private String tjyId;

  private String orgId;

  private String mediateFileName; //调解协议书名字

  private String mediateFileUrl; //调解协议书下载地址

  private String sqltSlzt; //诉前调解受理状态

  private Date sqltSlsj; //诉前调解受理时间

  private String sqltSlr; //诉前调解受理人

  private String sqltClfs; //诉前调解处理方式

  private Date sqltClsj; //诉前调解处理时间

  private String sqltClr; //诉前调解处理人

  private String sqltSfsqsfqr; //是否申请司法确认 1-是，2-否

  private String dispute;

  private String record;

  private String createUser;

  private Date createTime;

  private String updateUser;

  private Date updateTime;

  private Integer version;

  private Integer status;

  private String remark;

  private List<PersonnelInfoCollectResDTO> persons; //当事人

  private List<EvidenceInfoCollectResDTO> evidences; //证据
}