package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import com.beiming.odr.referee.enums.CaseProgressEnum;
import java.io.Serializable;
import lombok.Data;

/**
 * 案件导入关联查询
 * 
 * @author qsh
 *
 * @2019年3月1日
 */
@Data
@EncryptDecryptData
public class LawCaseResDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  private Long id;

  /**
   * 调解类型（人民调解，行政调解)
   */
  private String mediationType;

  /**
   * 案件录入人id
   */
  private Long creatorId;

  /**
   * 案件录入人的身份
   */
  private String creatorType;

  /**
   * 案件编号
   */
  @EncryptDecryptField
  private String caseNo;

  /**
   * 状态码(05纠纷被拒绝受理等)
   */
  private String lawCaseStatus;

  /**
   * 案件进度
   */
  private CaseProgressEnum caseProgress;

  /**
   * 咨询纠纷id，咨询转立案存入该值
   */
  private Long disputesId;

  /**
   * 纠纷类型字典表code
   */
  private String disputeTypeCode;
  /**
   * 纠纷类型
   */
  private String disputeType;
  /**
   * 机构id
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  private String createUser;

  private String updateUser;
}
