package com.beiming.odr.referee.enums;

/**
 * Created by zli on 2018/7/20. USER 前缀为用户 LEGAL_PERSON 法人和非法人组织 AGENT 代理人 MEDIATOR 调解员
 * <p>
 * 短信模版code
 */
public enum SMSCodeEnum {
  /**
   * 用户纠纷登记成功
   */
  USER_REGISTRATION_SUCCESS,
  /**
   * 通知单位纠纷登记成功
   */
  LEGAL_PERSON_REGISTRATION_SUCCESS,
  /**
   * 初次使用平台用户纠纷登记成功
   */
  USER_REGISTRATION_SUCCESS_FIRST,
  /**
   * 通知初次使用平台单位纠纷登记成功
   */
  LEGAL_PERSON_REGISTRATION_SUCCESS_FIRST,
  /**
   * 通知新增代理人审核通过
   */
  AGENT_NEW_APPROVAL_SUCCESS,
  /**
   * 通知代理人纠纷登记成功
   */
  AGENT_REGISTRATION_SUCCESS,
  /**
   * 通知初次使用平台代理人纠纷登记成功
   */
  AGENT_REGISTRATION_SUCCESS_FIRST,
  /**
   * 通知机构管理员纠纷登记成功
   */
  ADMIN_REGISTRATION_SUCCESS,
  /**
   * 通知信访代理人纠纷登记成功
   */
  PETITION_AGENT_REGISTRATION_SUCCESS,
  /**
   * 通知用户纠纷指派到哪个机构的哪调解员——申请人
   */
  USER_ASSIGNED_ORG_APPLICANT,
  /**
   * 通知单位纠纷指派到哪个机构的哪调解员——申请人
   */
  LEGAL_PERSON_ASSIGNED_ORG_APPLICANT,
  /**
   * 通知申请人代理人纠纷指派给调解员
   */
  AGENT_ASSIGNED_ORG_MEDIATOR,
  /**
   * 通知被申请人代理人纠纷指派给调解员
   */
  AGENT_ASSIGNED_ORG_MEDIATOR_FIRST,
  /**
   * 通知被申请人新代理人纠纷指派给调解员
   */
  AGENT_ASSIGNED_ORG_RESPONDENT_FIRST,
  /**
   * 通知用户纠纷指派到哪个机构的哪调解员——被申请人
   */
  USER_ASSIGNED_ORG_RESPONDENT,
  /**
   * 通知用户纠纷指派到哪个机构的哪调解员——新被申请人
   */
  USER_ASSIGNED_ORG_RESPONDENT_FIRST,
  /**
   * 通知单位纠纷指派到哪个机构的哪调解员——被申请人
   */
  LEGAL_PERSON_ASSIGNED_ORG_RESPONDENT,
  /**
   * 通知单位纠纷指派到哪个机构的哪调解员——新被申请人
   */
  LEGAL_PERSON_ASSIGNED_ORG_RESPONDENT_FIRST,
  /**
   * 通知用户纠纷分配到调解员
   */
  USER_ASSIGNED_MEDIATOR,
  /**
   * 通知单位纠纷分配到调解员
   */
  LEGAL_PERSON_ASSIGNED_MEDIATOR,
  /**
   * 通知初次使用平台用户纠纷分配到调解员
   */
  USER_ASSIGNED_MEDIATOR_FIRST,
  /**
   * 通知单位纠纷分配到调解员
   */
  LEGAL_PERSON_ASSIGNED_MEDIATOR_FIRST,
  /**
   * 通知代理人调解员受理纠纷（新代理人）
   */
  AGENT_ASSIGNED_MEDIATOR_FIRST,
  /**
   * 通知用户调解预约时间
   */
  USER_MEDIATOR_APPOINTMENT,
  /**
   * 通知单位调解预约时间
   */
  LEGAL_PERSON_MEDIATOR_APPOINTMENT,
  /**
   * 通知代理人调解预约时间
   */
  AGENT_MEDIATOR_APPOINTMENT,
  /**
   * 通知用户调解预约时间（通知新用户）
   */
  USER_MEDIATOR_APPOINTMENT_FIRST,
  /**
   * 通知单位调解预约时间（通知新用户）
   */
  LEGAL_PERSON_MEDIATOR_APPOINTMENT_FIRST,
  /**
   * 通知代理人调解预约时间（通知新代理人）
   */
  AGENT_PERSON_MEDIATOR_APPOINTMENT_FIRST,
  /**
   * 预约线下会议
   */
  USER_ASSIGNED_OFFLINE_MEETING,
  /**
   * 预约线下会议
   */
  LEGAL_PERSON_ASSIGNED_OFFLINE_MEETING,
  /**
   * 通知代理人预约线下会议
   */
  AGENT_PERSON_ASSIGNED_OFFLINE_MEETING,
  /**
   * 通知用户调查预约时间
   */
  USER_SURVEY_APPOINTMENT,
  /**
   * 通知单位调查预约时间
   */
  LEGAL_PERSON_SURVEY_APPOINTMENT,
  /**
   * 通知代理人调查预约时间
   */
  AGENT_PERSON_SURVEY_APPOINTMENT,
  /**
   * 通知用户调查预约时间（通知新用户）
   */
  USER_SURVEY_APPOINTMENT_FIRST,
  /**
   * 通知单位调查预约时间（通知新用户）
   */
  LEGAL_PERSON_SURVEY_APPOINTMENT_FIRST,
  /**
   * 通知代理人调查预约时间（通知新代理人）
   */
  AGENT_PERSON_SURVEY_APPOINTMENT_FIRST,
  /**
   * 通知用户调解员发布协议
   */
  USER_NOTIFY_PUBLISH_MEDIATOR,
  /**
   * 通知单位调解员发布协议
   */
  MONAD_NOTIFY_PUBLISH_MEDIATOR,
  /**
   * 通知代理人调解员发布协议
   */
  AGENT_NOTIFY_PUBLISH_MEDIATOR,
  /**
   * 通知信访代理人调解员发布协议
   */
  AGENT_PETITION_NOTIFY_PUBLISH_MEDIATOR,
  /**
   * 通知用户调解成功
   */
  USER_NOTIFY_SUCCESSFUL_MEDIATION,
  /**
   * 通知代理单位调解成功
   */
  MONAD_NOTIFY_SUCCESSFUL_MEDIATION,
  /**
   * 通知代理人调解成功
   */
  AGENT_NOTIFY_SUCCESSFUL_MEDIATION,
  /**
   * 通知用户调解失败
   */
  USER_NOTIFY_FAIL_MEDIATOR,
  /**
   * 通知单位调解失败
   */
  LEGAL_PERSON_NOTIFY_FAIL_MEDIATION,
  /**
   * 通知代理人调解失败
   */
  AGENT_NOTIFY_FAIL_MEDIATOR,
  /**
   * 通知用户需要重新分配调解员
   */
  USER_NOTIFY__REALLOCATE_MEDIATOR,
  /**
   * 通知单位需要重新分配调解员
   */
  LEGAL_PERSON_NOTIFY__REALLOCATE_MEDIATOR,
  /**
   * 通知代理人需要重新分配调解员
   */
  AGENT_NOTIFY__REALLOCATE_MEDIATOR,
  // 管理员短信模板
  /**
   * 通知管理员上线
   */
  ADNIM_NOTIFY_ONLINE,
  /**
   * 通知机构管理人员有新的纠纷流入
   */
  ORGANIZATION_INFORM_NEW_DISPUTES,
  /**
   * 通知机构管理员其他机构有纠纷转入
   */
  ORGANIZATION_INFORM_OTHER_TRANSFER_DISPUTES,
  /**
   * 通知机构管理人员调解员申请重新分配
   */
  ORGANIZATION_APPLY_REDISTRIBUTION_MEDIATOR,
  /**
   * 通知机构管理员纠纷调解失败
   */
  ORGANIZATION_DISPUTES_FAIL_MEDIATOR,
  /**
   * 通知机构管理员纠纷调解成功
   */
  ORGANIZATION_DISPUTES_SUCCESSFUL_MEDIATOR,
  /**
   * 调解员邀请观摩人员参与调解会议
   */
  INVITED_MEETING_MEDIATOR,
  /**
   * 调解员邀请观摩人员参与调查会议
   */
  INVITED_MEETING_SURVEY,
  /**
   * 通知用户发送手机验证码
   */
  USER_NOTIFY_SEND_VERIFICATION_CODE,
  /**
   * 通知咨询师客服转接向转接了一条咨询
   */
  CUSTOMER_INFORM_TRANSFER_REFERRAL,

  /** ------------撤回调解短信-----------------*/
  /**
   * 第一个申请人为个人
   */
  CANCEL_CASE_NOTICE_FIRST_APPLICANT_PERSONAL,
  /**
   * 其他申请人为个人
   */
  CANCEL_CASE_NOTICE_OTHER_APPLICANT_PERSONAL,
  /**
   * 第一个申请人为企业
   */
  CANCEL_CASE_NOTICE_FIRST_APPLICANT_COMPANY,
  /**
   * 其他申请人为企业
   */
  CANCEL_CASE_NOTICE_OTHER_APPLICANT_COMPANY,
  /**
   * 申请人的代理人
   */
  CANCEL_CASE_NOTICE_APPLICANT_AGENT,
  /**
   * 被申请人为个人
   */
  CANCEL_CASE_NOTICE_RESPONDENT_PERSONAL,
  /**
   * 被申请人为企业
   */
  CANCEL_CASE_NOTICE_RESPONDENT_COMPANY,
  /**
   * 被申请人代理人
   */
  CANCEL_CASE_NOTICE_RESPONDENT_AGENT,

  /**
   * 撤回案件通知调解员
   */
  CANCEL_CASE_NOTICE_MEDIATOR,

  /**
   * 撤回案件通知机构管理员
   */
  CANCEL_CASE_NOTICE_ADMIN,
  /**
   * 撤回案件通知信访代理人
   */
  CANCEL_CASE_NOTICE_PETITION_AGENT,
  /**
   * 申请人不受理短信
   */
  USER_REJECT_COMPLAINT,

  // 通知调解员
  /**
   * 通知调解员机构分配了新的任务
   */
  MEDIATOR_ALLOCATION,
  /**
   * 信访代理人会议线下调查 调解 共用
   */
  AGENT_PETITION_OFFLINE_SURVEY_MEDIATOR,
  /**
   * 信访代理人会议调查 调解 共用
   */
  AGENT_PETITION_SURVEY_MEDIATOR,
  /**
   * 信访代理人调解失败
   */
  AGENT_PETITION_FAIL_MEDIATOR,
  /**
   * 信访代理人调解成功
   */
  AGENT_PETITION_SUCCESSFUL_MEDIATOR,
  /**
   * 通知信访代理人需要重新分配调解员
   */
  AGENT_PETITION_REALLOCATE_MEDIATOR,
  /**
   * 信访代理人不受理案件
   */
  AGENT_PETITION_REJECT_COMPLAINT,

  /**
   * 调解结案后，通知申请人评价调解员的短信
   */
  EVALUATE_MEDIATOR_APPLICANT_MESSAGE,
  /**
   * 调解结案后 ，通知被申请人评价调解员的短信
   */
  EVALUATE_MEDIATOR_REAPPLICANT_MESSAGE,
  /**
   * 调解结案后，通知信访委托人评价信访代理人的短信
   */
  AGENT_PETITION_APPLICANT_MESSAGE,
  /**
   * 调解结案后，通知被申请人评价信访代理人的短信
   */
  AGENT_PETITION_REAPPLICANT_MESSAGE,
  /**
   * 时间段
   */
  CASE_MONITOR_PAST_TIME,
  /**
   * 再过N天
   */
  CASE_MONITOR_AFTER_N_DAYS,
  /**
   * 新用户注册
   */
  USER_ACCOUNT_PASSWORD_TIPS,
  /**
   * 通知管理员延长调解期限
   */
  ADMIN_EXTEND_SUCCESS,
  /**
   * 通知当事人自然人延长调解期限
   */
  PARTY_EXTEND_SUCCESS,
  /**
   * 通知当事人代理人延长调解期限
   */
  AGENT_EXTEND_SUCCESS,
  /**
   * 通知用户调解员发布调解笔录
   */
  USER_NOTIFY_PUBLISH_RECORD,
  /**
   * 通知单位调解员发布调解笔录
   */
  MONAD_NOTIFY_PUBLISH_RECORD,
  /**
   * 通知代理人调解员发布调解笔录
   */
  AGENT_NOTIFY_PUBLISH_RECORD,
  /**
   * 通知用户调解员发布无异议
   */
  USER_NOTIFY_PUBLISH_NO_DISSENT,
  /**
   * 通知单位调解员发布无异议
   */
  MONAD_NOTIFY_PUBLISH_NO_DISSENT,
  /**
   * 通知代理人调解员发布无异议
   */
  AGENT_NOTIFY_PUBLISH_NO_DISSENT,
  /**
   * 通知用户调解员发布无争议
   */
  USER_NOTIFY_PUBLISH_UNDISPUTED,
  /**
   * 通知单位调解员发布无争议
   */
  MONAD_NOTIFY_PUBLISH_UNDISPUTED,
  /**
   * 通知代理人调解员发布无争议
   */
  AGENT_NOTIFY_PUBLISH_UNDISPUTED,
  /**
   * 引调案件通知机构管理员
   */
  YT_NOTIFY_ADMIN,
  /**
   * 通知当事人共道注册
   */
  PARTY_GONGDAO_REGISTER,

  /**
   * 延期申请提示短信
   */
  MEDIATOR_EXTEND_SMS,
  /**
   * 调解发送用户关联账户
   */
  USER_MEDIATOR_APPOINTMENT_RELATE,
  /**
   * 调解发送单位关联账户
   */
  LEGAL_PERSON_MEDIATOR_APPOINTMENT_RELATE,
  /**
   * 调解发送代理人关联账户
   */
  AGENT_PERSON_MEDIATOR_APPOINTMENT_RELATE,
  /**
   * 调查发送用户关联账户
   */
  USER_SURVEY_APPOINTMENT_RELATE,
  /**
   * 调查发送单位关联账户
   */
  LEGAL_PERSON_SURVEY_APPOINTMENT_RELATE,
  /**
   * 调查发送代理人关联账户
   */
  AGENT_PERSON_SURVEY_APPOINTMENT_RELATE,
  /**
   * 通知用户纠纷登记成功关联账户
   */
  USER_REGISTRATION_SUCCESS_RELATE,
  /**
   * 通知单位纠纷登记成功关联账户
   */
  LEGAL_PERSON_REGISTRATION_SUCCESS_RELATE,
  /**
   * 通知关联用户纠纷分配到调解员
   */
  USER_ASSIGNED_MEDIATOR_RELATE,
  /**
   * 通知关联单位纠纷分配到调解员
   */
  LEGAL_PERSON_ASSIGNED_MEDIATOR_RELATE,
  /**
   * 通知关联用户指派调解员被申请人
   */
  USER_ASSIGNED_ORG_RESPONDENT_RELATE,
  /**
   * 通知关联单位指派调解员被申请人
   */
  LEGAL_PERSON_ASSIGNED_ORG_RESPONDENT_RELATE,
  /**
   * 通知被申请人关联代理指派调解员
   */
  AGENT_ASSIGNED_ORG_RESPONDENT_RELATE,
  /**
   * 信访代理人关联账户调查调解
   */
  AGENT_PETITION_SURVEY_MEDIATOR_RELATE,
  /**
   * 信访代理人新用户调查，调解
   */
  AGENT_PETITION_SURVEY_MEDIATOR_FIRST,
  /**
   * 督促履行通知被告
   */
  FINANCIAL_URGE_PERFORM_RESPONDENT,
  /**
   * 金融类案撤案通知被告
   */
  FINANCIAL_WITHDRAW_RESPONDENT,
  /**
   * 提交案件通知被告
   */
  FINANCIAL_SAVE_CASE_RESPONDENT,
  /**
   * 审核通过催告函通知被告
   */
  FINANCIAL_REMINDER_RESPONDENT,
  /**
   * 和解声明通知被告
   */
  FINANCIAL_COMPRM_STATEMENT_RESPONDENT,
  /**
   * 调解效果通知被告
   */
  FINANCIAL_MEDIATION_EFFECT_RESPONDENT,
  /**
   * 受理通知被告
   */
  FINANCIAL_CASE_ACCEPT_NOTICE,
  /**
   * 超期结案
   */
  FINANCIAL_EXCEED_DEADLINE,
  /**
   * 机构48小时未受理短信提醒
   */
  THE_INSTITUTION_HAS_NOT_ACCEPTED,

  /**
   * 强制修改密码通知
   */
  FORCE_UPDATE_PWD,

  /**
   * 通知司法确认申请人司法确认书已返回
   */
  USER_JUDICIAL_CONFIRM_BOOK_SUCCESS,

  /**
   * 通知司法确认申请人司法确认审核成功
   */
  NOTIFY_USER_JUDICIAL_CONFIRM_BOOK_SUCCESS,

  /**
   * 通知司法确认申请人司法确认审核失败
   */
  NOTIFY_USER_JUDICIAL_CONFIRM_BOOK_FAIL,

  /**
   * 通知调解员当事人申请司法确认
   */
  NOTIFY_MEDIATOR_JUDICIAL_CONFIRM_BOOK,

  /**
   * 通知司法确认当事人调解员已经签名
   */
  NOTIFY_USER_JUDICIAL_CONFIRM_BOOK_SIGNATURE,

  /**
   * 通知申请出具调解书已返回
   */
  USER_MEDIATION_APPLY_BOOK_SUCCESS,

  /**
   * 案件结束日期倒计时3天的短信提醒
   */
  CASE_THREE_DAYS_COUNTDOWN_REMINDER,

  /**
   * 通知申请人和被申请人等填写满意度调查
   */
  USER_NOTIFY_SATISFACTION_EVALUATION,

  /**
   * 流转处理提醒
   */
  REMIND_TRANSFER_ACCEPT,
  /**
   * 未分配调解员提醒
   */
  REMIND_ASSIGNED_MEDIATOR,
  /**
   * 调解预约提醒
   */
  REMIND_ORDER_MEDIATION,
  /**
   * 回访提醒
   */
  REMIND_VIST_RECORD,
  /**
   * 转立案提醒
   */
  REMIND_SUIT_APPLY,
  /**
   * 分配跟进调解员提醒
   */
  REMIND_FOLLOW_MEDIATION,
  REMIND_FOLLOW_END,
  SUBMIT_AUDIT_SUCCESS,
  ASSIGN_AUDIT_USER,
  AUDIT_CHECK_SUCCESS,
  AUDIT_CHECK_FAIL;
}
