package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.DisputeStatisticsConfigDTO;
import com.beiming.odr.referee.dto.CaseStatisticsReqDTO;
import com.beiming.odr.referee.dto.DisputeStatisticsDetailRequestDTO;
import com.beiming.odr.referee.dto.responsedto.DisputeStatisticsDetailRespDTO;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 纠纷统计服务列表
 *
 * @author liubao
 * @date 2024/07/23
 */
public interface CaseDisputeStatisticsServiceApi {

  /**
   * 机构调解案件报表统计
   */
  DubboResult<ArrayList<Map<String, Object>>> mediationCaseCount(CaseStatisticsReqDTO reqDTO);

  /**
   * 机构诉讼案件报表统计
   */
  DubboResult<ArrayList<Map<String, Object>>> litigationCaseCount(CaseStatisticsReqDTO reqDTO);

  /**
   * 机构仲裁案件报表统计
   */
  DubboResult<ArrayList<Map<String, Object>>> arbitrationCaseCount(CaseStatisticsReqDTO reqDTO);

  /**
   * 查询纠纷类型对应案由
   */
  DubboResult<ArrayList<Map<String, Object>>> getDisputeTypeAy(List<String> disputeType);

  /**
   * 分析案件列表下钻1
   */
  DubboResult<PageInfo<DisputeStatisticsDetailRespDTO>> statisticsCaseList(
      DisputeStatisticsDetailRequestDTO requestDTO);


  /**
   * 获取报表表头下钻
   * @return
   */
  List<DisputeStatisticsConfigDTO> getConfig();

  /**
   * 修改报表配置
   * @param list
   * @return
   */
  DubboResult updateConfig(List<DisputeStatisticsConfigDTO> list);

  /**
   * 获取表里的字段信息
   * @param s
   * @return
   */
  List<DisputeStatisticsConfigDTO> getFields(String s);
}
