package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.dto.requestdto.AttachmentListReqDTO;
import com.beiming.odr.referee.dto.requestdto.DelFileReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossGeneraterReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossierAnalysisReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossierAuditFailReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossierFileReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossierListReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossierRemarkReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawCaseDossierDirectoryReqDTO;
import com.beiming.odr.referee.dto.responsedto.CprmAmountAnalysisResDTO;
import com.beiming.odr.referee.dto.responsedto.DisplayDossierResDTO;
import com.beiming.odr.referee.dto.responsedto.DisputeAmountAnalysisResDTO;
import com.beiming.odr.referee.dto.responsedto.DisputeTypeAnalysisResDTO;
import com.beiming.odr.referee.dto.responsedto.DossAttachmentResDTO;
import com.beiming.odr.referee.dto.responsedto.DossierAttchmentListResDTO;
import com.beiming.odr.referee.dto.responsedto.DossierPigeonholeResDTO;
import com.beiming.odr.referee.dto.responsedto.DossierStatisticsResDTO;
import com.beiming.odr.referee.dto.responsedto.DossierVolumeResDTO;
import com.beiming.odr.referee.dto.responsedto.DosssierTemplateResDTO;
import com.beiming.odr.referee.dto.responsedto.LawAttachmentResDTO;
import com.beiming.odr.referee.dto.responsedto.LawCaseDossierDirectoryResDTO;
import com.beiming.odr.referee.dto.responsedto.LawProgressResDTO;
import com.beiming.odr.referee.dto.responsedto.StoragePeriodAnalysisResDTO;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;


/**
 * 卷宗api
 *
 * @author qsh
 * @data 2018年6月28日
 */
@Valid
public interface LawCaseDossierApi {

  /**
   * 通过案件id查询案件对应文件
   *
   * @param caseId
   * @return
   */
  DubboResult<ArrayList<LawAttachmentResDTO>> getLawAttachment(@Valid @NotNull(message = "{common.parameter.is.null}") Long caseId, String objectType);

  /**
   * 通过案件id查询生成卷宗
   *
   * @param dossGeneraterReqDTO
   * @return
   */
  DubboResult getGenerateFile(@Valid DossGeneraterReqDTO dossGeneraterReqDTO );

  /**
   * 卷宗列表
   *
   * @return
   */
  DubboResult<PageInfo<DossierAttchmentListResDTO>> getDossierList(@Valid DossierListReqDTO dossierListReqDTO);

  /**
   * 进度详情
   *
   * @param caseId
   * @return
   */
  DubboResult<ArrayList<LawProgressResDTO>> queryDossierList(Long caseId, String subjectType);

  /**
   * 卷宗审核失败
   *
   * @param caseId
   * @return
   */
  DubboResult dossierBack(DossierAuditFailReqDTO dossierAuditFailReqDTO);

  /**
   * 撤销卷宗信息
   *
   * @param caseId
   * @return
   */
  DubboResult backOutDossier(Long dossierId);

  /**
   * 提交卷宗审核 agreementNumber 协议编号 remark 备注
   *
   * @param dossierId
   * @return
   */
  DubboResult submitLawCaseDossier(Long dossierId, String agreementNumber, String remark,
      Integer storagePeriod);

  /**
   * 卷宗审核通过
   *
   * @param caseId
   * @return
   */
  DubboResult auditLawCaseDossierPass(Long caseId, Long userId, String userName);

  /**
   * 电子卷宗上传文件
   *
   * @return
   */
  DubboResult saveDossierFile(DossierFileReqDTO dossierFileReqDTO);


  /**
   * 卷宗数据回显
   *
   * @param caseId
   * @return
   */
  DubboResult<DisplayDossierResDTO> displayFileDossier(@Valid @NotNull(message = "{common.parameter.is.null}") Long caseId);

  /**
   * 删除文件
   *
   * @param fileId
   * @param caseId
   * @return
   */
  DubboResult delDossierFile(DelFileReqDTO delFileReqDTO);

  /**
   * 查询文件信息
   *
   * @param caseId
   * @param categoryBig
   * @param categoryMiddle
   * @return
   */
  DubboResult<ArrayList<DossAttachmentResDTO>> attachmentList(
      AttachmentListReqDTO attachmentListReqDTO);

  /**
   * 修改卷宗备注信息
   *
   * @return
   */
  DubboResult modifyDossierName(DossierRemarkReqDTO dossierRemarkReqDTO);

  /**
   * 查询卷宗信息
   *
   * @return
   */
  DubboResult<DossierVolumeResDTO> queryDossier(Long dossierId);

  /**
   * @date 2018-09-28 查询卷宗文件附件用于卷内目录
   * @param caseId
   * @return
   */
  DubboResult<ArrayList<DossAttachmentResDTO>> queryAttachmentListDossier(@Valid @NotNull(
      message = "{common.parameter.is.null}") Long caseId);

  /**
   * @date 卷宗模板类型字典
   * @param type  模板类型，1.常规卷宗；2.简易卷宗
   * @return
   */
  DubboResult<ArrayList<DosssierTemplateResDTO>> queryTemplateListDossier(String type,
      Integer isDefault);

  /**
   * 操作卷宗目录（新增）
   *
   * @param lawCaseDossierDirectoryReqDTO
   * @return
   */
  DubboResult<String> addDossierDirectory(
      LawCaseDossierDirectoryReqDTO lawCaseDossierDirectoryReqDTO);

  /**
   * 更新/删除目录
   */
  DubboResult<String> operDossierDirectory(
      LawCaseDossierDirectoryReqDTO lawCaseDossierDirectoryReqDTO);

  /**
   * caseid查目录
   */
  DubboResult<ArrayList<LawCaseDossierDirectoryResDTO>> queryDirectoryByCaseId(Long caseId);

  /**
   * 电子卷宗统计分析纠纷类型
   */
  DubboResult<ArrayList<DisputeTypeAnalysisResDTO>> queryDisputeTypeAnalysis(
      DossierAnalysisReqDTO dossierAnalysisReqDTO);

  /**
   * 电子卷宗统计分析纠纷金额
   */
  DubboResult<ArrayList<DisputeAmountAnalysisResDTO>> queryDisputeAmountDossierAnalysis(
      DossierAnalysisReqDTO dossierAnalysisReqDTO);
  /**
   * 电子卷宗统计分析保管年限
   */
  DubboResult<ArrayList<StoragePeriodAnalysisResDTO>> queryStoragePeriodDossierAnalysis(
      DossierAnalysisReqDTO dossierAnalysisReqDTO);

  /**
   * 电子卷宗归档时间分析
   */
  DubboResult<ArrayList<DossierPigeonholeResDTO>> queryDossierPigeonholeAnalysis(
      DossierAnalysisReqDTO dossierAnalysisReqDTO);

  /**
   * 卷宗统计
   */
  DubboResult<PageInfo<DossierStatisticsResDTO>> searchDossierStatistics(DossierAnalysisReqDTO dossierAnalysisReqDTO);

  /**
   * 电子卷宗统计分析和解金额
   */
  DubboResult<ArrayList<CprmAmountAnalysisResDTO>> queryCprmAmountDossierAnalysis(
      DossierAnalysisReqDTO dossierAnalysisReqDTO);
}
