package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.MediationExtendRegionalConfirmReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationExtendReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationListReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationListResDTO;

import javax.validation.Valid;
import java.util.ArrayList;

/**
 * 调解延期API
 *
 * @author XZY 2019年1月7日
 *
 */
@Valid
public interface MediationExtendApi {
  /**
  * @Description:  发起延期申请
  * @Param: [mediationExtendReqDTO]
  * @return: com.beiming.framework.domain.DubboResult
  * @Author: XZY
  * @Date:  2019/1/9/009
  */
  DubboResult saveMediationExtend(MediationExtendReqDTO mediationExtendReqDTO);

  DubboResult<ArrayList<MediationListResDTO>> listMediationInfoExcel(@Valid MediationListReqDTO reqDTO);
  /**
   * 申请延期之区域管理员审批
   */
  DubboResult mediationExtendConfirmByRegion(MediationExtendRegionalConfirmReqDTO mediationExtendConfirmReqDTO);

  /**
   * 案件列表总数查询接口
   */
  DubboResult<Integer> countMediation(@Valid MediationListReqDTO reqDTO);
}
