package com.beiming.odr.referee.dto.requestdto;

import com.beiming.framework.page.PageQuery;
import com.beiming.odr.referee.dto.TdhCountReqDTO;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @ClassName CiteReportReqDTO
 * @Description 引调报表请求参数
 * @Author Tang
 * @Date 16:16 2019/9/9
 **/
@Data
public class CiteReportReqDTO extends PageQuery implements Serializable {

  private static final long serialVersionUID = 9028279327407505120L;
  @NotNull
  private String startCreateTime; //开始时间
  @NotNull
  private String endCreateTime; //结束时间
  @NotNull
  private String interfaceType; //接口类型，PULL_YT_CASE("1", "引调案件")
  @NotNull
  private String odrType; //系统标识，GH_ODR("广互odr", "ghodr")

  /*
   *@Author TangYu
   *@Description dto转换
   *@Date 17:27 2019/9/9
   */
  public TdhCountReqDTO convertToTdhCountReqDTO() {
    TdhCountReqDTO tdhCountReqDTO = new TdhCountReqDTO();
    tdhCountReqDTO.setStartCreateTime(this.getStartCreateTime());
    tdhCountReqDTO.setEndCreateTime(this.getEndCreateTime());
    tdhCountReqDTO.setInterfaceType(this.getInterfaceType());
    tdhCountReqDTO.setOdrType(this.getOdrType());
    tdhCountReqDTO.setPageIndex(this.getPageIndex());
    tdhCountReqDTO.setPageSize(this.getPageSize());
    return tdhCountReqDTO;
  }
}
