package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.dto.responsedto.CaseMaterialResDTO;
import com.beiming.odr.referee.enums.MediationSuccessEnum;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;

/**
 * 草稿保存类
 * 继承案件保存DTO，并在此基础上加入简易案件信息
 */
@Data
@EncryptDecryptData
public class DraftMediationCaseReqDTO  implements Serializable {


  /**
   * 草稿ID
   */
  private Long id;

  /**
   * 案件保存的json，在mastiff封装
   */
  private String saveCaseJson;

  /**
   * 是否简易案件 1是0否
   */
  private Integer simple;

  /**
   * 案件发生时间
   */
  private Date happenTime;

  /**
   * 案件材料 常规案件不传
   */
  private List<CaseMaterialResDTO> documents;

  /**
   * 调解结果
   */
  private MediationSuccessFailReqDTO mediationResult;


  /**
   * 保存案件后赋值
   */
  @ApiModelProperty(notes = "案件id", example = "484")
  private Long caseId;


  private  Long createId;

  private String createUser;

  /**
   * 案件状态
   */
  private String caseProgress;


  private String remark;

  @ApiModelProperty(notes = "撤回,失败原因类型")
  private MediationSuccessEnum reasonType;
}
