package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by chenjt 2019/03/06
 *
 * 操作者
 */
@Data
@NoArgsConstructor
public class LawCaseImportExistReqDTO implements Serializable {

  private static final long serialVersionUID = -4056657800838724680L;

  /**
   * 上传的原文件名
   */
  @NotNull(message = "{common.parameter.is.null}")
  @Size(min = 1, message = "{common.parameter.is.null}")
  private List<String> fileNames;

  /**
   * 模板大类目录
   */
  private String categoryDirectory;

  /**
   * 模板小类
   */
  private String templateEnum;

  public LawCaseImportExistReqDTO(List<String> fileNames, String categoryDirectory, String templateEnum) {
    this.fileNames = fileNames;
    this.categoryDirectory = categoryDirectory;
    this.templateEnum = templateEnum;
  }
}
