package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 保存异议书的请求对象
 * 
 * @author DJQ 2018年7月8日
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MediationDissentSaveReqDTO implements Serializable {

  private static final long serialVersionUID = 2763857461448263390L;

  @NotNull(message = "{case.id.cannot.be.empty}")
  private Long lawCaseId; // 案件号
  @NotNull(message = "{user.id.cannot.be.empty}")
  private Long userId;
  @NotNull(message = "{parameter.mediation.scheme.id.null}")
  private Long mediationSchemeId; // 调解方案ID
  @NotNull(message = "{user.type.cannot.be.empty}")
  private String userType; // 用户类型
  
  private Long documentId;
  private Long personnelId; // Personnel主键
  private String userName; // 用户名称
  private String caseUserType; // 用户案件角色
  private String sex; // 性别
  private String phone; // 电话号
  private String idCard; // 身份证号
  private String provCode; // 省Code
  private String cityCode; // 市Code
  private String areaCode; // 区Code
  private String streetCode; // 街道Code
  private String provName; // 省Name
  private String cityName; // 市Name
  private String areaName; // 区Name
  private String streetName; // 街Name
  private String address; // 地址
  private String content; // 文本内容

  private String email; //邮寄地址
}
