package com.beiming.odr.referee.dto.responsedto;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 案件人员-数据响应DTO
 * @author xiaoying
 * @date 2021/12/10
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CasePersonnelResDTO implements Serializable {

  private static final long serialVersionUID = -7719004967037558229L;

  @ApiModelProperty(notes = "主键Id", example = "666")
  private Long id;

  @ApiModelProperty(notes = "案件号", example = "666")
  private String caseNum;

  @ApiModelProperty(notes = "案件id", example = "666")
  private Long lawCaseId;

  @ApiModelProperty(notes = "文书类型", example = "666")
  private String documentType;

  @ApiModelProperty(notes = "文书id", example = "666")
  private Long documentId;

  @ApiModelProperty(notes = "用户id", example = "666")
  private Long userId;

  @ApiModelProperty(notes = "案件用户类型（申请人 ,被申请人, 调解员）", example = "666")
  private String caseUserType;

  @ApiModelProperty(notes = "用户类型（自然人,法人,非法人组织）", example = "666")
  private String userType;

  @ApiModelProperty(notes = "名称(类别为法人/非法人组织时, 填单位名称)", example = "666")
  private String userName;

  @ApiModelProperty(notes = "性别", example = "666")
  private String sex;

  @ApiModelProperty(notes = "联系电话", example = "666")
  private String phone;

  @ApiModelProperty(notes = "身份证号", example = "666")
  private String idCard;

  @ApiModelProperty(notes = "证件类型", example = "666")
  private String cardType;

  @ApiModelProperty(notes = "信用代码", example = "666")
  private String creditCode;

  @ApiModelProperty(notes = "法人代表", example = "666")
  private String corporation;

}