/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.referee.dto;

import com.beiming.odr.referee.dto.requestdto.MediationCaseAgentReqDTO;
import com.beiming.odr.referee.enums.ApprovalStatusEnum;
import com.beiming.odr.referee.enums.CardTypeEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public class CaseAgentTdhDTO
implements Serializable {
    @JsonProperty(value="dlrzt")
    private String mode;
    @JsonProperty(value="dlrmc")
    @NotNull
    private String agentName;
    @JsonProperty(value="dldsr")
    @NotNull
    private String litigantName;
    @JsonProperty(value="xb")
    private String sex;
    @JsonProperty(value="mz")
    private String ethnicity;
    @JsonProperty(value="csrq")
    private String birthDate;
    @JsonProperty(value="sfzhm")
    private String idCardNum;
    @JsonProperty(value="zyzh")
    private String licenseNum;
    @JsonProperty(value="sjhm")
    private String phone;
    @JsonProperty(value="dz")
    private String address;
    @JsonProperty(value="szdw")
    private String workAddress;
    @JsonProperty(value="dlrxh")
    private String agentCiteId;

    public CaseAgentTdhDTO(MediationCaseAgentReqDTO reqDTO) {
        this.address = reqDTO.getAddress();
        this.mode = ApprovalStatusEnum.NEW.getCode().toString();
        if (CardTypeEnum.PRC_IDENTITY_CARD.getTdhCode().equals(reqDTO.getCardType())) {
            String birthday;
            this.birthDate = birthday = StringUtils.substring((String)reqDTO.getIdCard(), (int)6, (int)14);
        }
        this.ethnicity = reqDTO.getNation();
        this.sex = reqDTO.getSex();
        this.agentName = reqDTO.getAgentName();
        this.idCardNum = reqDTO.getIdCard();
        this.phone = reqDTO.getPhone();
        this.litigantName = reqDTO.getLitigantName();
        this.licenseNum = reqDTO.getLawyerCardNum();
    }

    public static CaseAgentTdhDTOBuilder builder() {
        return new CaseAgentTdhDTOBuilder();
    }

    public String getMode() {
        return this.mode;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public String getLitigantName() {
        return this.litigantName;
    }

    public String getSex() {
        return this.sex;
    }

    public String getEthnicity() {
        return this.ethnicity;
    }

    public String getBirthDate() {
        return this.birthDate;
    }

    public String getIdCardNum() {
        return this.idCardNum;
    }

    public String getLicenseNum() {
        return this.licenseNum;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getAddress() {
        return this.address;
    }

    public String getWorkAddress() {
        return this.workAddress;
    }

    public String getAgentCiteId() {
        return this.agentCiteId;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public void setLitigantName(String litigantName) {
        this.litigantName = litigantName;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public void setEthnicity(String ethnicity) {
        this.ethnicity = ethnicity;
    }

    public void setBirthDate(String birthDate) {
        this.birthDate = birthDate;
    }

    public void setIdCardNum(String idCardNum) {
        this.idCardNum = idCardNum;
    }

    public void setLicenseNum(String licenseNum) {
        this.licenseNum = licenseNum;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setWorkAddress(String workAddress) {
        this.workAddress = workAddress;
    }

    public void setAgentCiteId(String agentCiteId) {
        this.agentCiteId = agentCiteId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaseAgentTdhDTO)) {
            return false;
        }
        CaseAgentTdhDTO other = (CaseAgentTdhDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        String this$agentName = this.getAgentName();
        String other$agentName = other.getAgentName();
        if (this$agentName == null ? other$agentName != null : !this$agentName.equals(other$agentName)) {
            return false;
        }
        String this$litigantName = this.getLitigantName();
        String other$litigantName = other.getLitigantName();
        if (this$litigantName == null ? other$litigantName != null : !this$litigantName.equals(other$litigantName)) {
            return false;
        }
        String this$sex = this.getSex();
        String other$sex = other.getSex();
        if (this$sex == null ? other$sex != null : !this$sex.equals(other$sex)) {
            return false;
        }
        String this$ethnicity = this.getEthnicity();
        String other$ethnicity = other.getEthnicity();
        if (this$ethnicity == null ? other$ethnicity != null : !this$ethnicity.equals(other$ethnicity)) {
            return false;
        }
        String this$birthDate = this.getBirthDate();
        String other$birthDate = other.getBirthDate();
        if (this$birthDate == null ? other$birthDate != null : !this$birthDate.equals(other$birthDate)) {
            return false;
        }
        String this$idCardNum = this.getIdCardNum();
        String other$idCardNum = other.getIdCardNum();
        if (this$idCardNum == null ? other$idCardNum != null : !this$idCardNum.equals(other$idCardNum)) {
            return false;
        }
        String this$licenseNum = this.getLicenseNum();
        String other$licenseNum = other.getLicenseNum();
        if (this$licenseNum == null ? other$licenseNum != null : !this$licenseNum.equals(other$licenseNum)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$workAddress = this.getWorkAddress();
        String other$workAddress = other.getWorkAddress();
        if (this$workAddress == null ? other$workAddress != null : !this$workAddress.equals(other$workAddress)) {
            return false;
        }
        String this$agentCiteId = this.getAgentCiteId();
        String other$agentCiteId = other.getAgentCiteId();
        return !(this$agentCiteId == null ? other$agentCiteId != null : !this$agentCiteId.equals(other$agentCiteId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CaseAgentTdhDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        String $agentName = this.getAgentName();
        result = result * 59 + ($agentName == null ? 43 : $agentName.hashCode());
        String $litigantName = this.getLitigantName();
        result = result * 59 + ($litigantName == null ? 43 : $litigantName.hashCode());
        String $sex = this.getSex();
        result = result * 59 + ($sex == null ? 43 : $sex.hashCode());
        String $ethnicity = this.getEthnicity();
        result = result * 59 + ($ethnicity == null ? 43 : $ethnicity.hashCode());
        String $birthDate = this.getBirthDate();
        result = result * 59 + ($birthDate == null ? 43 : $birthDate.hashCode());
        String $idCardNum = this.getIdCardNum();
        result = result * 59 + ($idCardNum == null ? 43 : $idCardNum.hashCode());
        String $licenseNum = this.getLicenseNum();
        result = result * 59 + ($licenseNum == null ? 43 : $licenseNum.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $workAddress = this.getWorkAddress();
        result = result * 59 + ($workAddress == null ? 43 : $workAddress.hashCode());
        String $agentCiteId = this.getAgentCiteId();
        result = result * 59 + ($agentCiteId == null ? 43 : $agentCiteId.hashCode());
        return result;
    }

    public String toString() {
        return "CaseAgentTdhDTO(mode=" + this.getMode() + ", agentName=" + this.getAgentName() + ", litigantName=" + this.getLitigantName() + ", sex=" + this.getSex() + ", ethnicity=" + this.getEthnicity() + ", birthDate=" + this.getBirthDate() + ", idCardNum=" + this.getIdCardNum() + ", licenseNum=" + this.getLicenseNum() + ", phone=" + this.getPhone() + ", address=" + this.getAddress() + ", workAddress=" + this.getWorkAddress() + ", agentCiteId=" + this.getAgentCiteId() + ")";
    }

    public CaseAgentTdhDTO(String mode, String agentName, String litigantName, String sex, String ethnicity, String birthDate, String idCardNum, String licenseNum, String phone, String address, String workAddress, String agentCiteId) {
        this.mode = mode;
        this.agentName = agentName;
        this.litigantName = litigantName;
        this.sex = sex;
        this.ethnicity = ethnicity;
        this.birthDate = birthDate;
        this.idCardNum = idCardNum;
        this.licenseNum = licenseNum;
        this.phone = phone;
        this.address = address;
        this.workAddress = workAddress;
        this.agentCiteId = agentCiteId;
    }

    public CaseAgentTdhDTO() {
    }

    public static class CaseAgentTdhDTOBuilder {
        private String mode;
        private String agentName;
        private String litigantName;
        private String sex;
        private String ethnicity;
        private String birthDate;
        private String idCardNum;
        private String licenseNum;
        private String phone;
        private String address;
        private String workAddress;
        private String agentCiteId;

        CaseAgentTdhDTOBuilder() {
        }

        public CaseAgentTdhDTOBuilder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public CaseAgentTdhDTOBuilder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public CaseAgentTdhDTOBuilder litigantName(String litigantName) {
            this.litigantName = litigantName;
            return this;
        }

        public CaseAgentTdhDTOBuilder sex(String sex) {
            this.sex = sex;
            return this;
        }

        public CaseAgentTdhDTOBuilder ethnicity(String ethnicity) {
            this.ethnicity = ethnicity;
            return this;
        }

        public CaseAgentTdhDTOBuilder birthDate(String birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public CaseAgentTdhDTOBuilder idCardNum(String idCardNum) {
            this.idCardNum = idCardNum;
            return this;
        }

        public CaseAgentTdhDTOBuilder licenseNum(String licenseNum) {
            this.licenseNum = licenseNum;
            return this;
        }

        public CaseAgentTdhDTOBuilder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public CaseAgentTdhDTOBuilder address(String address) {
            this.address = address;
            return this;
        }

        public CaseAgentTdhDTOBuilder workAddress(String workAddress) {
            this.workAddress = workAddress;
            return this;
        }

        public CaseAgentTdhDTOBuilder agentCiteId(String agentCiteId) {
            this.agentCiteId = agentCiteId;
            return this;
        }

        public CaseAgentTdhDTO build() {
            return new CaseAgentTdhDTO(this.mode, this.agentName, this.litigantName, this.sex, this.ethnicity, this.birthDate, this.idCardNum, this.licenseNum, this.phone, this.address, this.workAddress, this.agentCiteId);
        }

        public String toString() {
            return "CaseAgentTdhDTO.CaseAgentTdhDTOBuilder(mode=" + this.mode + ", agentName=" + this.agentName + ", litigantName=" + this.litigantName + ", sex=" + this.sex + ", ethnicity=" + this.ethnicity + ", birthDate=" + this.birthDate + ", idCardNum=" + this.idCardNum + ", licenseNum=" + this.licenseNum + ", phone=" + this.phone + ", address=" + this.address + ", workAddress=" + this.workAddress + ", agentCiteId=" + this.agentCiteId + ")";
        }
    }
}

