/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import com.beiming.odr.referee.dto.MediationCaseAgentPersonnelDTO;
import com.beiming.odr.referee.dto.MediationCasePersonnelDTO;
import com.beiming.odr.referee.dto.requestdto.CaseProtocolAgentPersonnelReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationDissentSaveReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseProtocolAgentPersonnelResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseProtocolPersonnelResDTO;
import com.beiming.odr.referee.enums.CaseUserTypeEnum;
import com.beiming.odr.referee.enums.UserSexEnum;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

@EncryptDecryptData
public class CaseProtocolPersonnelReqDTO
implements Serializable {
    private static final long serialVersionUID = 7988498493297314452L;
    private Long personnelId;
    private Long caseId;
    private Long documentId;
    private CaseUserTypeEnum caseUserType;
    private String userType;
    private Long userId;
    private String userName;
    @EncryptDecryptField
    private String phone;
    private UserSexEnum sex;
    private String cardType;
    @EncryptDecryptField
    private String idCard;
    private String provCode;
    private String cityCode;
    private String areaCode;
    private String streetCode;
    private String provName;
    private String cityName;
    private String areaName;
    private String streetName;
    @EncryptDecryptField
    private String address;
    @EncryptDecryptField
    private String creditCode;
    private String corporation;
    private Integer order;
    private String email;
    private String nationalityName;
    private String nationName;
    private String cardTypeName;
    @EncryptDecryptField
    private List<CaseProtocolAgentPersonnelReqDTO> agentList;
    private String nationality;
    private String nation;

    public CaseProtocolPersonnelReqDTO(MediationCasePersonnelDTO casePer) {
        this.setUserId(casePer.getUserId());
        this.setUserType(casePer.getUserType());
        this.setPhone(casePer.getPhone());
        this.setCaseUserType(CaseUserTypeEnum.valueOf(casePer.getCaseUserType()));
        this.setUserName(casePer.getName());
        if (!StringUtils.isBlank((CharSequence)casePer.getSex())) {
            this.setSex(UserSexEnum.valueOf(casePer.getSex()));
        }
        this.setIdCard(casePer.getIdCard());
        this.setProvCode(casePer.getProvCode());
        this.setCityCode(casePer.getCityCode());
        this.setAreaCode(casePer.getAreaCode());
        this.setStreetCode(casePer.getStreetCode());
        this.setProvName(casePer.getProvName());
        this.setCityName(casePer.getCityName());
        this.setAreaName(casePer.getAreaName());
        this.setStreetName(casePer.getStreetName());
        this.setAddress(casePer.getAddress());
        this.setOrder(casePer.getUserOrder());
        this.setEmail(casePer.getEmail());
        List<MediationCaseAgentPersonnelDTO> agents = casePer.getAgentList();
        this.agentList = CollectionUtils.isEmpty(agents) ? Lists.newArrayList() : agents.stream().map(MediationCaseAgentPersonnelDTO::caseProtocolAgentPersonnelReqDTOConvert).collect(Collectors.toList());
    }

    public CaseProtocolPersonnelReqDTO(CaseProtocolPersonnelResDTO casePer) {
        this.setUserId(casePer.getUserId());
        this.setUserType(casePer.getUserType());
        this.setPhone(casePer.getPhone());
        this.setCaseUserType(CaseUserTypeEnum.valueOf(casePer.getCaseUserType()));
        this.setUserName(casePer.getUserName());
        if (!StringUtils.isBlank((CharSequence)casePer.getSex())) {
            this.setSex(UserSexEnum.valueOf(casePer.getSex()));
        }
        this.setIdCard(casePer.getIdCard());
        this.setProvCode(casePer.getProvCode());
        this.setCityCode(casePer.getCityCode());
        this.setAreaCode(casePer.getAreaCode());
        this.setStreetCode(casePer.getStreetCode());
        this.setProvName(casePer.getProvName());
        this.setCityName(casePer.getCityName());
        this.setAreaName(casePer.getAreaName());
        this.setStreetName(casePer.getStreetName());
        this.setAddress(casePer.getAddress());
        this.setOrder(casePer.getUserOrder());
        this.setEmail(casePer.getEmail());
        List<CaseProtocolAgentPersonnelResDTO> agents = casePer.getAgentList();
        this.agentList = CollectionUtils.isEmpty(agents) ? Lists.newArrayList() : agents.stream().map(CaseProtocolAgentPersonnelResDTO::caseProtocolAgentPersonnelReqDTOConvert).collect(Collectors.toList());
    }

    public CaseProtocolPersonnelReqDTO(MediationDissentSaveReqDTO reqDTO) {
        this.setUserId(reqDTO.getUserId());
        this.setPhone(reqDTO.getPhone());
        this.setUserType(reqDTO.getUserType());
        this.setCaseUserType(CaseUserTypeEnum.valueOf(reqDTO.getCaseUserType()));
        this.setUserName(reqDTO.getUserName());
        if (!StringUtils.isBlank((CharSequence)reqDTO.getSex())) {
            this.setSex(UserSexEnum.valueOf(reqDTO.getSex()));
        }
        this.setIdCard(reqDTO.getIdCard());
        this.setProvCode(reqDTO.getProvCode());
        this.setCityCode(reqDTO.getCityCode());
        this.setAreaCode(reqDTO.getAreaCode());
        this.setStreetCode(reqDTO.getStreetCode());
        this.setProvName(reqDTO.getProvName());
        this.setCityName(reqDTO.getCityName());
        this.setAreaName(reqDTO.getAreaName());
        this.setStreetName(reqDTO.getStreetName());
        this.setAddress(reqDTO.getAddress());
        this.setEmail(reqDTO.getEmail());
    }

    public Long getPersonnelId() {
        return this.personnelId;
    }

    public Long getCaseId() {
        return this.caseId;
    }

    public Long getDocumentId() {
        return this.documentId;
    }

    public CaseUserTypeEnum getCaseUserType() {
        return this.caseUserType;
    }

    public String getUserType() {
        return this.userType;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPhone() {
        return this.phone;
    }

    public UserSexEnum getSex() {
        return this.sex;
    }

    public String getCardType() {
        return this.cardType;
    }

    public String getIdCard() {
        return this.idCard;
    }

    public String getProvCode() {
        return this.provCode;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public String getStreetCode() {
        return this.streetCode;
    }

    public String getProvName() {
        return this.provName;
    }

    public String getCityName() {
        return this.cityName;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public String getAddress() {
        return this.address;
    }

    public String getCreditCode() {
        return this.creditCode;
    }

    public String getCorporation() {
        return this.corporation;
    }

    public Integer getOrder() {
        return this.order;
    }

    public String getEmail() {
        return this.email;
    }

    public String getNationalityName() {
        return this.nationalityName;
    }

    public String getNationName() {
        return this.nationName;
    }

    public String getCardTypeName() {
        return this.cardTypeName;
    }

    public List<CaseProtocolAgentPersonnelReqDTO> getAgentList() {
        return this.agentList;
    }

    public String getNationality() {
        return this.nationality;
    }

    public String getNation() {
        return this.nation;
    }

    public void setPersonnelId(Long personnelId) {
        this.personnelId = personnelId;
    }

    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }

    public void setCaseUserType(CaseUserTypeEnum caseUserType) {
        this.caseUserType = caseUserType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setSex(UserSexEnum sex) {
        this.sex = sex;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public void setProvCode(String provCode) {
        this.provCode = provCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public void setProvName(String provName) {
        this.provName = provName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setCreditCode(String creditCode) {
        this.creditCode = creditCode;
    }

    public void setCorporation(String corporation) {
        this.corporation = corporation;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setNationalityName(String nationalityName) {
        this.nationalityName = nationalityName;
    }

    public void setNationName(String nationName) {
        this.nationName = nationName;
    }

    public void setCardTypeName(String cardTypeName) {
        this.cardTypeName = cardTypeName;
    }

    public void setAgentList(List<CaseProtocolAgentPersonnelReqDTO> agentList) {
        this.agentList = agentList;
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaseProtocolPersonnelReqDTO)) {
            return false;
        }
        CaseProtocolPersonnelReqDTO other = (CaseProtocolPersonnelReqDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$personnelId = this.getPersonnelId();
        Long other$personnelId = other.getPersonnelId();
        if (this$personnelId == null ? other$personnelId != null : !((Object)this$personnelId).equals(other$personnelId)) {
            return false;
        }
        Long this$caseId = this.getCaseId();
        Long other$caseId = other.getCaseId();
        if (this$caseId == null ? other$caseId != null : !((Object)this$caseId).equals(other$caseId)) {
            return false;
        }
        Long this$documentId = this.getDocumentId();
        Long other$documentId = other.getDocumentId();
        if (this$documentId == null ? other$documentId != null : !((Object)this$documentId).equals(other$documentId)) {
            return false;
        }
        CaseUserTypeEnum this$caseUserType = this.getCaseUserType();
        CaseUserTypeEnum other$caseUserType = other.getCaseUserType();
        if (this$caseUserType == null ? other$caseUserType != null : !((Object)((Object)this$caseUserType)).equals((Object)other$caseUserType)) {
            return false;
        }
        String this$userType = this.getUserType();
        String other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !this$userType.equals(other$userType)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        UserSexEnum this$sex = this.getSex();
        UserSexEnum other$sex = other.getSex();
        if (this$sex == null ? other$sex != null : !((Object)((Object)this$sex)).equals((Object)other$sex)) {
            return false;
        }
        String this$cardType = this.getCardType();
        String other$cardType = other.getCardType();
        if (this$cardType == null ? other$cardType != null : !this$cardType.equals(other$cardType)) {
            return false;
        }
        String this$idCard = this.getIdCard();
        String other$idCard = other.getIdCard();
        if (this$idCard == null ? other$idCard != null : !this$idCard.equals(other$idCard)) {
            return false;
        }
        String this$provCode = this.getProvCode();
        String other$provCode = other.getProvCode();
        if (this$provCode == null ? other$provCode != null : !this$provCode.equals(other$provCode)) {
            return false;
        }
        String this$cityCode = this.getCityCode();
        String other$cityCode = other.getCityCode();
        if (this$cityCode == null ? other$cityCode != null : !this$cityCode.equals(other$cityCode)) {
            return false;
        }
        String this$areaCode = this.getAreaCode();
        String other$areaCode = other.getAreaCode();
        if (this$areaCode == null ? other$areaCode != null : !this$areaCode.equals(other$areaCode)) {
            return false;
        }
        String this$streetCode = this.getStreetCode();
        String other$streetCode = other.getStreetCode();
        if (this$streetCode == null ? other$streetCode != null : !this$streetCode.equals(other$streetCode)) {
            return false;
        }
        String this$provName = this.getProvName();
        String other$provName = other.getProvName();
        if (this$provName == null ? other$provName != null : !this$provName.equals(other$provName)) {
            return false;
        }
        String this$cityName = this.getCityName();
        String other$cityName = other.getCityName();
        if (this$cityName == null ? other$cityName != null : !this$cityName.equals(other$cityName)) {
            return false;
        }
        String this$areaName = this.getAreaName();
        String other$areaName = other.getAreaName();
        if (this$areaName == null ? other$areaName != null : !this$areaName.equals(other$areaName)) {
            return false;
        }
        String this$streetName = this.getStreetName();
        String other$streetName = other.getStreetName();
        if (this$streetName == null ? other$streetName != null : !this$streetName.equals(other$streetName)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$creditCode = this.getCreditCode();
        String other$creditCode = other.getCreditCode();
        if (this$creditCode == null ? other$creditCode != null : !this$creditCode.equals(other$creditCode)) {
            return false;
        }
        String this$corporation = this.getCorporation();
        String other$corporation = other.getCorporation();
        if (this$corporation == null ? other$corporation != null : !this$corporation.equals(other$corporation)) {
            return false;
        }
        Integer this$order = this.getOrder();
        Integer other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$nationalityName = this.getNationalityName();
        String other$nationalityName = other.getNationalityName();
        if (this$nationalityName == null ? other$nationalityName != null : !this$nationalityName.equals(other$nationalityName)) {
            return false;
        }
        String this$nationName = this.getNationName();
        String other$nationName = other.getNationName();
        if (this$nationName == null ? other$nationName != null : !this$nationName.equals(other$nationName)) {
            return false;
        }
        String this$cardTypeName = this.getCardTypeName();
        String other$cardTypeName = other.getCardTypeName();
        if (this$cardTypeName == null ? other$cardTypeName != null : !this$cardTypeName.equals(other$cardTypeName)) {
            return false;
        }
        List<CaseProtocolAgentPersonnelReqDTO> this$agentList = this.getAgentList();
        List<CaseProtocolAgentPersonnelReqDTO> other$agentList = other.getAgentList();
        if (this$agentList == null ? other$agentList != null : !((Object)this$agentList).equals(other$agentList)) {
            return false;
        }
        String this$nationality = this.getNationality();
        String other$nationality = other.getNationality();
        if (this$nationality == null ? other$nationality != null : !this$nationality.equals(other$nationality)) {
            return false;
        }
        String this$nation = this.getNation();
        String other$nation = other.getNation();
        return !(this$nation == null ? other$nation != null : !this$nation.equals(other$nation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CaseProtocolPersonnelReqDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $personnelId = this.getPersonnelId();
        result = result * 59 + ($personnelId == null ? 43 : ((Object)$personnelId).hashCode());
        Long $caseId = this.getCaseId();
        result = result * 59 + ($caseId == null ? 43 : ((Object)$caseId).hashCode());
        Long $documentId = this.getDocumentId();
        result = result * 59 + ($documentId == null ? 43 : ((Object)$documentId).hashCode());
        CaseUserTypeEnum $caseUserType = this.getCaseUserType();
        result = result * 59 + ($caseUserType == null ? 43 : ((Object)((Object)$caseUserType)).hashCode());
        String $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : $userType.hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        UserSexEnum $sex = this.getSex();
        result = result * 59 + ($sex == null ? 43 : ((Object)((Object)$sex)).hashCode());
        String $cardType = this.getCardType();
        result = result * 59 + ($cardType == null ? 43 : $cardType.hashCode());
        String $idCard = this.getIdCard();
        result = result * 59 + ($idCard == null ? 43 : $idCard.hashCode());
        String $provCode = this.getProvCode();
        result = result * 59 + ($provCode == null ? 43 : $provCode.hashCode());
        String $cityCode = this.getCityCode();
        result = result * 59 + ($cityCode == null ? 43 : $cityCode.hashCode());
        String $areaCode = this.getAreaCode();
        result = result * 59 + ($areaCode == null ? 43 : $areaCode.hashCode());
        String $streetCode = this.getStreetCode();
        result = result * 59 + ($streetCode == null ? 43 : $streetCode.hashCode());
        String $provName = this.getProvName();
        result = result * 59 + ($provName == null ? 43 : $provName.hashCode());
        String $cityName = this.getCityName();
        result = result * 59 + ($cityName == null ? 43 : $cityName.hashCode());
        String $areaName = this.getAreaName();
        result = result * 59 + ($areaName == null ? 43 : $areaName.hashCode());
        String $streetName = this.getStreetName();
        result = result * 59 + ($streetName == null ? 43 : $streetName.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $creditCode = this.getCreditCode();
        result = result * 59 + ($creditCode == null ? 43 : $creditCode.hashCode());
        String $corporation = this.getCorporation();
        result = result * 59 + ($corporation == null ? 43 : $corporation.hashCode());
        Integer $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $nationalityName = this.getNationalityName();
        result = result * 59 + ($nationalityName == null ? 43 : $nationalityName.hashCode());
        String $nationName = this.getNationName();
        result = result * 59 + ($nationName == null ? 43 : $nationName.hashCode());
        String $cardTypeName = this.getCardTypeName();
        result = result * 59 + ($cardTypeName == null ? 43 : $cardTypeName.hashCode());
        List<CaseProtocolAgentPersonnelReqDTO> $agentList = this.getAgentList();
        result = result * 59 + ($agentList == null ? 43 : ((Object)$agentList).hashCode());
        String $nationality = this.getNationality();
        result = result * 59 + ($nationality == null ? 43 : $nationality.hashCode());
        String $nation = this.getNation();
        result = result * 59 + ($nation == null ? 43 : $nation.hashCode());
        return result;
    }

    public String toString() {
        return "CaseProtocolPersonnelReqDTO(personnelId=" + this.getPersonnelId() + ", caseId=" + this.getCaseId() + ", documentId=" + this.getDocumentId() + ", caseUserType=" + (Object)((Object)this.getCaseUserType()) + ", userType=" + this.getUserType() + ", userId=" + this.getUserId() + ", userName=" + this.getUserName() + ", phone=" + this.getPhone() + ", sex=" + (Object)((Object)this.getSex()) + ", cardType=" + this.getCardType() + ", idCard=" + this.getIdCard() + ", provCode=" + this.getProvCode() + ", cityCode=" + this.getCityCode() + ", areaCode=" + this.getAreaCode() + ", streetCode=" + this.getStreetCode() + ", provName=" + this.getProvName() + ", cityName=" + this.getCityName() + ", areaName=" + this.getAreaName() + ", streetName=" + this.getStreetName() + ", address=" + this.getAddress() + ", creditCode=" + this.getCreditCode() + ", corporation=" + this.getCorporation() + ", order=" + this.getOrder() + ", email=" + this.getEmail() + ", nationalityName=" + this.getNationalityName() + ", nationName=" + this.getNationName() + ", cardTypeName=" + this.getCardTypeName() + ", agentList=" + this.getAgentList() + ", nationality=" + this.getNationality() + ", nation=" + this.getNation() + ")";
    }

    public CaseProtocolPersonnelReqDTO(Long personnelId, Long caseId, Long documentId, CaseUserTypeEnum caseUserType, String userType, Long userId, String userName, String phone, UserSexEnum sex, String cardType, String idCard, String provCode, String cityCode, String areaCode, String streetCode, String provName, String cityName, String areaName, String streetName, String address, String creditCode, String corporation, Integer order, String email, String nationalityName, String nationName, String cardTypeName, List<CaseProtocolAgentPersonnelReqDTO> agentList, String nationality, String nation) {
        this.personnelId = personnelId;
        this.caseId = caseId;
        this.documentId = documentId;
        this.caseUserType = caseUserType;
        this.userType = userType;
        this.userId = userId;
        this.userName = userName;
        this.phone = phone;
        this.sex = sex;
        this.cardType = cardType;
        this.idCard = idCard;
        this.provCode = provCode;
        this.cityCode = cityCode;
        this.areaCode = areaCode;
        this.streetCode = streetCode;
        this.provName = provName;
        this.cityName = cityName;
        this.areaName = areaName;
        this.streetName = streetName;
        this.address = address;
        this.creditCode = creditCode;
        this.corporation = corporation;
        this.order = order;
        this.email = email;
        this.nationalityName = nationalityName;
        this.nationName = nationName;
        this.cardTypeName = cardTypeName;
        this.agentList = agentList;
        this.nationality = nationality;
        this.nation = nation;
    }

    public CaseProtocolPersonnelReqDTO() {
    }
}

