package com.beiming.odr.referee.dto;

import com.beiming.framework.page.PageQuery;
import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * 纠纷统计报表详情列表页请求参数
 *
 * @author liubao
 * @date 2024/07/31
 */
@Data
@ApiModel(description = "纠纷统计报表详情列表页请求参数")
@EncryptDecryptData
public class DisputeStatisticsDetailRequestDTO extends PageQuery implements Serializable {

  private static final long serialVersionUID = -1769219434410989912L;

  @ApiModelProperty(value = "检索关键词")
  private String keyWord;

  @ApiModelProperty(value = "调解案件案号加密检索")
  @EncryptDecryptField
  private String caseNo;

  @ApiModelProperty(value = "解纷结果")
  private String caseProgress;

  @ApiModelProperty(value = "立案开始时间")
  private String startTime;

  @ApiModelProperty(value = "立案结束时间")
  private String endTime;

  @ApiModelProperty(value = "结案开始时间")
  private String jaStartTime;

  @ApiModelProperty(value = "结案结束时间")
  private String jaEndTime;

  @ApiModelProperty(value = "数据来源 mediate-调解案件 litigation-诉讼案件 arbitration-仲裁案件")
  private String source = "mediate";

  @ApiModelProperty(value = "点击下钻类型 4-机构人员数下钻 1-收案数 2-结案数 3-未结案件数")
  private Integer clickType;

  @ApiModelProperty(value = "机构id")
  private Long orgId;

  @ApiModelProperty(value = "法院代码")
  private String courtCode;

  @ApiModelProperty(value = "人员id")
  private String userId;

  @ApiModelProperty(value = "人员对应法综账号")
  private String yhdm;

  @ApiModelProperty(value = "纠纷类型code")
  private String disputeTypeCode;

  @ApiModelProperty(value = "解纷类型对应案由代码")
  private List<String> aydms;

  @ApiModelProperty(value = "调解案件已结状态码")
  private List<String> completeCaseStatus;
}
