package com.beiming.odr.referee.dto;

import java.io.Serializable;
import java.util.List;
import lombok.Data;


/**
 * @author jiangfan
 * @date 2025/09/01
 */
@Data
public class TurnArbitrationCaseDTO implements Serializable {

  /**
   * 法院案件唯一标识
   */
  private Long id;

  /**
   * 仲裁案件唯一标识(ID)（和法院id一一对应）
   */
  private String arbitrateId;

  /**
   * 案由
   */
  private String caseReason;

  /**
   * 案件类型
   */
  private Integer caseType;

  /**
   * 标的金额，争议金额（元）
   */
  private Integer amount;

  /**
   * 仲裁请求 请求被申请人向申请人支付9月的租金5000000元
   */
  private String arbitrationClause;

  /**
   * 案件申请时间
   */
  private String applyTime;

  /**
   * 法院仲裁申请书唯一标识(ID)
   */
  private Long attamentApplyId;

  /**
   * 仲裁申请书文件唯一标识(ID)（和法院id一一对应）
   */
  private String attamentApplyArbitrateId;

  /**
   * 仲裁申请书名称
   */
  private String attamentApplyName;

  /**
   * 仲裁申请书文件内容(base64)
   */
  private String attamentApplyConent;

  /**
   * 法院仲裁协议唯一标识(ID)
   */
  private Long attamentAgreementId;

  /**
   * 仲裁仲裁协议文书唯一标识(ID)（和法院id一一对应）
   */
  private String attamentAgreementArbitrateId;

  /**
   * 仲裁协议名称
   */
  private String attamentAgreementName;

  /**
   * 仲裁协议文件内容
   */
  private String attamentAgreementConent;

  /**
   * 证据材料列表
   */
  private List<TurnArbitrationEvidenceDTO> evidences;

  /**
   * 案件当事人列表
   */
  private List<TurnArbitrationPersonalsDTO> personals;

  private String errorMsg;
}
