package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import lombok.Data;

/**
 * 添加待办列表请求参数
 * 
 * @author qsh
 *
 * @2019年7月31日
 */
@Data
public class AddGuangDongReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  /**
   * 第三方接口id
   */
  private String id;

  /**
   * 身份证号码
   */
  private String creadentialId;
  /**
   * 事项所属业务名称
   */
  private String title;
  /**
   * 事项提示语
   */
  private String tips;
  /**
   * 事项创建时间
   */
  private Long createTime;
  /**
   * 服务商的业务单id
   */
  private String orderId;
  /**
   * 待办类型,1待处理，2办理中，3已办结
   */
  private int type;

  /**
   * 30为广东数字案件服务 服务商的业务id，公积金为1，出入境为2，仲裁为3,婚姻4，居住证5,交管6，残疾人7，出生证8，工商(数字肇庆,
   * 营商环境引入)9，社保10，高层次人才11，南方人才市场入户广州12，微达安-监管13，中大凯旋行政预约14，新增加的找后台申请新的service_id
   */

  private int serviceId;

  /**
   * 跳转按钮对应的跳转url
   */
  private String handleUrl;

  /**
   * 业务自定义子类
   */
  private String subType;
  /**
   * 服务商自定义的扩展字段
   */
  private String extFiled;
  /**
   * 新接入的厂商需要把version赋值为1，点击待办列表
   */
  private int version;
  /**
   * 超时时间戳
   */
  private Long expireTime;

  private Long userId;
  private String userName;
  private Long caseId;

  /**
   * 机构id
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 扩展字段，做粤商通标志
   */
  private String remark;
}
