package com.beiming.odr.referee.dto.requestdto;

import com.beiming.framework.page.PageQuery;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

@Data
public class LawCaseSubsidyQueryDTO extends PageQuery implements Serializable {

  /**
   * 案件ID
   */
  private Long lawCaseId;

  /**
   * 案件编号
   */
  @EncryptDecryptField
  private String caseNo;

  /**
   * 审核状态
   */
  private String auditStatus;

  /**
   * 金额最小
   */
  private BigDecimal amountMin;

  /**
   * 金额最大
   */
  private BigDecimal amountMax;

  /**
   * 到账状态 0未到账 1已到账
   */
  private Integer confirmStatus;


  /**
   * 标签
   */
  private String caseTag;


  /**
   * 创建人ID
   */
  @JsonIgnore
  private Long createId;


  /**
   * 申请时间开始
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeStart;

  /**
   * 申请时间结束
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeEnd;


  @JsonIgnore
  private String currentAreaManagerCode;

  /**
   * 无需传递
   */
  @JsonIgnore
  private Integer startIndex;

  private List<Long> ids;


  /**
   * 组织机构
   */
  private List<Long> orgIds;

  public Integer getStartIndex() {
    if (getPageIndex() != null && getPageSize() != null) {
      return getPageSize() * (getPageIndex() - 1);
    }
    return null;
  }

  public void setStartIndex() {
    if (getPageIndex() != null && getPageSize() != null) {
      startIndex = getPageSize() * (getPageIndex() - 1);
    }
  }
}
