package com.beiming.odr.referee.dto.requestdto.haoda;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 文书材料
 *
 * @author xiaoying
 * @date 2021/12/10
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ApplyDocument implements Serializable {

  private static final long serialVersionUID = -7719004967037558229L;

  /**
   * 1 起诉状或申请书
   * 2 主要证据材料
   * 7 管辖依据材料
   * 101 司法确认申请书
   * 115 调解协议
   * B5 材料清单
   * B6 送达地址确认书
   */
  @ApiModelProperty(notes = "材料类型(提供类型为必传材料，司法确认申请书为司法确认收案必传)", example = "666")
  private String fileType;

  @ApiModelProperty(notes = "文件格式:只支持pdf/jpg/jpeg格式）", example = "666")
  private String fileFormat;

  @ApiModelProperty(notes = "材料名称", example = "666")
  private String fileName;

  @ApiModelProperty(notes = "材料URL，提供文件下载", example = "666")
  private String fileUrl;

  @ApiModelProperty(notes = "材料ID", example = "666")
  private String fileId;

}