package com.beiming.odr.referee.dto.requestdto.haoda;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 昊达获得Token请求DTO
 * @author xiaoying
 * @date 2021/12/07
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class HaoDaTokenReqDTO implements Serializable {

  private static final long serialVersionUID = -3209068441805383190L;

  /**
   * 授权类型 固定为  authorization_code
   */
  @JsonProperty("grant_type")
  private String grantType;

  /**
   * 昊达分配的id
   */
  @JsonProperty("client_id")
  private String clientId;

  @JsonProperty("client_secret")
  private String clientSecret;

  /**
   * 默认值all
   */
  private String scope = "all";

  /**
   * 请求地址
   */
  private String basicUrl;
}