package com.beiming.odr.referee.dto.responsedto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import java.io.Serializable;
import lombok.Data;

/**
 * @Author batman lin chen
 * @Date 2022/12/14 16:58
 * @Version 1.0 司法确认统计展示类
 */
@Data
public class JudicialShowResDTO implements Serializable {

  //预审数
  @ExcelProperty(value = "预审待分配数", index = 2)
  private int reviewNumber;
  //预审分配数
  @ExcelProperty(value = "预审已分配数", index = 3)
  private int reviewHandleNumber;
  //预审通过数
  @ExcelProperty(value = "预审通过数", index = 4)
  private int reviewPassNumber;
  //预审不通过数
  @ExcelProperty(value = "预审不通过数", index = 5)
  private int reviewStopNumber;
  //提交通过数
  @ExcelProperty(value = "提交诉服平台", index = 6)
  private int submitNumber;
  //入库成功
  @ExcelProperty(value = "诉服入库成功", index = 7)
  private int submitSuccessNumber;
  //入库失败
  @ExcelProperty(value = "诉服入库失败", index = 8)
  private int submitFailNumber;
  //司法确认成功
  @ExcelProperty(value = "司法确认诉讼审核通过", index = 9)
  private int judicialSuccessNumber;
  //司法确认失败
  @ExcelProperty(value = "司法确认诉讼审核不通过", index = 10)
  private int judicialFailNumber;
  //机构
  @ExcelIgnore
  private Long orgId;
  //机构名
  @ExcelProperty(value = "机构名", index = 1)
  private String orgName;
  //地区名
  @ExcelProperty(value = "地区名", index = 0)
  private String areaName;
  //地区code
  @ExcelIgnore
  private String areaCode;
  //总数
  @ExcelIgnore
  private int total;

}
