package com.beiming.odr.referee.enums;

/**
 * 调解成功,失败类型
 *
 * @author jache
 * @data 2019年1月11日
 */
public enum MediationSuccessEnum {
  /** 调解成功 */
  BOTH_CONFIRMEND("双方都确认调解协议"), OTHER("其他"),

  /** 调解失败 */
  BOTH_CONFIRMEND_FAIL("双方调解协议未达成一致"), APPLICANT_NOT_MEDIATE("原告要求终结"), RESPONDENT_NOT_MEDIATE("被告要求终结"),
  RESPONDENT_NOT_DELIVER("被告无法送达"), PARTIES_UNABLE_CONTACT("当事人联系不上调解失败"), MEDIATE_TO_SUIT("调解失败转诉讼"),
  MEDIATE_FAIL_OTHER("其他"),
  /**撤回调解*/
  RETRACT_PARTIES_UNABLE_CONTACT("一方当事人联系不上"), RETRACT_PARTIES_NOT_MEDIATE("一方当事人不同意调解"),
  RETRACT_PARTIES("一方当事人要求撤回调解"), RETRACT_OTHER("撤回调解-其他"),

  /** 调解终止 */
  NO_CONTACT_PARTY("联系不到当事人"), ONESIDE_REFUSE_MEDIATE("一方当事人不同意调解"), PARTY_REGRET("当事人临时反悔"), OVER_TIME("案件超过调解期限"),
  FEEL_MEAN("身体不适"),
  WORK_RECENTLY("近期工作多"),
  RELEVANT_EXPERIENCE("个人没有相关经验"),
  DISPUTE_NOT_AGENCY("纠纷不适合本机构");

  private String name;


  /**
   * @param name
   */
  private MediationSuccessEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public static MediationSuccessEnum getByCode(String code) {
    for (MediationSuccessEnum item : MediationSuccessEnum.values()) {
      if (item.name().equals(code)) {
        return item;
      }
    }
    return MediationSuccessEnum.OTHER;
  }

}
