package com.beiming.odr.referee.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description:字符串工具类
 */
@Slf4j
public class TimeStampToStrUtil {

  /** 字符串时间戳，转化为，yyyy-MM-dd HH:mm:ss 的字符串 */
  public static String timeStampToStr(String timeStamp) {
    if (StringUtils.isBlank(timeStamp)) {
      return StringUtils.EMPTY;
    }
    DateTimeFormatter ftf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    return ftf.format(LocalDateTime.ofInstant(
        Instant.ofEpochMilli(Long.parseUnsignedLong(timeStamp)), ZoneId.systemDefault()));
  }


}
