package com.beiming.odr.referee.util.sm4util;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

/**
 * @author HUAWEI
 * @description: AES 加解密工具类 使用AES-128-ECB加密模式
 * @date 2022/08/22
 */
@Slf4j
public class AesEncryptUtils {
  /**
   * AES 加解密密钥，请勿擅自修改！！！
   */
  private static final String PUBLIC_AES_KEY = "DGODR20228AESECB";

  /**
   * AES 加密 使用AES-128-ECB加密模式
   *
   * @param source 需要加密的字段
   * @param sKey   16 位密钥
   * @return
   * @throws Exception
   */
  public static String encrypt(String source, String sKey) {
    try {
      if (sKey == null) {
        log.info("Key为空null");
        return null;
      }
      /** 判断Key是否为16位 */
      if (sKey.length() != 16) {
        log.info("Key长度不是16位");
        return null;
      }
      SecretKey strKey = generateMySQLAESKey(PUBLIC_AES_KEY, "ASCII");
      Cipher cipher = Cipher.getInstance("AES");
      cipher.init(Cipher.ENCRYPT_MODE, strKey);
      byte[] cleartext = source.getBytes("UTF-8");
      byte[] ciphertextBytes = cipher.doFinal(cleartext);
      return new String(Hex.encodeHex(ciphertextBytes));

    } catch (Exception e) {
      e.printStackTrace();
      log.error(source + " AES解密异常：{}", e);
      return null;
    }
  }

  /**
   * 数据加密
   * @param source
   * @return
   */
  public static String encrypt(String source) {
    if (StringUtils.isEmpty(source)) {
      return source;
    } else {
      return encrypt(source, PUBLIC_AES_KEY);
    }
  }

  /**
   * AES 解密 使用AES-128-ECB加密模式
   *
   * @param source 需要解密的字段
   * @param sKey   16 位密钥
   * @return
   * @throws Exception
   */
  public static String decrypt(String source, String sKey) {
    try {
      // 判断Key是否正确
      if (sKey == null) {
        log.info("Key为空null");
        return null;
      }
      // 判断Key是否为16位
      if (sKey.length() != 16) {
        log.info("Key长度不是16位");
        return null;
      }
      SecretKey aesKeyValue = generateMySQLAESKey(PUBLIC_AES_KEY, "ASCII");
      Cipher cipher = Cipher.getInstance("AES");
      cipher.init(Cipher.DECRYPT_MODE, aesKeyValue);
      byte[] cleartext = Hex.decodeHex(source.toCharArray());
      byte[] ciphertextBytes = cipher.doFinal(cleartext);
      return new String(ciphertextBytes, "UTF-8");
    } catch (Exception e) {
      e.printStackTrace();
      log.error(source + " AES解密异常：{}", e);
      return null;
    }
  }

  /**
   * 数据解密
   * @param source
   * @return
   */
  public static String decrypt(String source) {
    if (StringUtils.isEmpty(source)) {
      return source;
    } else {
      return decrypt(source, PUBLIC_AES_KEY);
    }
  }

  public static SecretKeySpec generateMySQLAESKey(final String key, final String encoding) {
    try {
      final byte[] finalKey = new byte[16];
      int i = 0;
      for (byte b : key.getBytes(encoding)) {
        finalKey[i++ % 16] ^= b;
      }
      return new SecretKeySpec(finalKey, "AES");
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

//  public static void main(String[] args) {
//    String value = decrypt("7d83fb968a8f1864a6bc213731157c7d017e509d5ab39c10309366810dca7b58");
//    log.info("解密后的值:{}", value);
//    value = decrypt("7ee220aa8f352057a54c5850c002a3b9017e509d5ab39c10309366810dca7b58");
//    log.info("解密后的值:{}", value);
//    value = encrypt("532926198804101515");
//    log.info("加密后的值:{}", value);
//  }
}