/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.referee.enums;

import com.beiming.odr.referee.dto.MediationCaseProgressDTO;
import java.util.ArrayList;
import java.util.List;

public enum CaseProgressEnum {
    TRANSFER("\u5df2\u8f6c\u79fb"),
    APPLY("\u63d0\u4ea4\u7533\u8bf7"),
    REFUSE("\u5df2\u9000\u56de"),
    WAIT("\u7b49\u5f85\u8c03\u89e3"),
    RETRACT("\u64a4\u56de\u8c03\u89e3"),
    START("\u6b63\u5728\u8c03\u89e3"),
    FAIL("\u8c03\u89e3\u5931\u8d25"),
    SUCCESS("\u8c03\u89e3\u6210\u529f"),
    JUDICIAL("\u53f8\u6cd5\u786e\u8ba4"),
    ONLINE("\u7f51\u4e0a\u7acb\u6848"),
    TURN("\u5df2\u6d41\u8f6c"),
    WAIT_CONFIRM("\u5f85\u53d7\u7406"),
    BEGIN("\u8c03\u89e3\u5f00\u59cb"),
    WAIT_ASSGIN("\u5f85\u5206\u914d"),
    WAIT_HANDLE("\u5904\u7406\u4e2d"),
    WAIT_PUSH("\u9700\u63a8\u9001"),
    WAIT_FOLLOW("\u5f85\u8ddf\u8fdb"),
    FOLLOW_END("\u5df2\u8ddf\u8fdb");

    private String name;

    private CaseProgressEnum(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static List<MediationCaseProgressDTO> getCaseProgressList(CaseProgressEnum enumObj) {
        ArrayList<MediationCaseProgressDTO> lst = new ArrayList<MediationCaseProgressDTO>();
        CaseProgressEnum.setCaseProgress(lst, APPLY, enumObj, 1, false);
        CaseProgressEnum.setCaseProgress(lst, WAIT_CONFIRM, enumObj, 2, false);
        CaseProgressEnum.setCaseProgress(lst, REFUSE, enumObj, 3, true);
        CaseProgressEnum.setCaseProgress(lst, WAIT, enumObj, 4, true);
        CaseProgressEnum.setCaseProgress(lst, TURN, enumObj, 5, true);
        CaseProgressEnum.setCaseProgress(lst, TRANSFER, enumObj, 5, true);
        CaseProgressEnum.setCaseProgress(lst, RETRACT, enumObj, 6, true);
        CaseProgressEnum.setCaseProgress(lst, START, enumObj, 7, true);
        CaseProgressEnum.setCaseProgress(lst, FAIL, enumObj, 8, true);
        CaseProgressEnum.setCaseProgress(lst, SUCCESS, enumObj, 9, true);
        CaseProgressEnum.setCaseProgress(lst, JUDICIAL, enumObj, 10, true);
        CaseProgressEnum.setCaseProgress(lst, ONLINE, enumObj, 11, true);
        return lst;
    }

    private static List<MediationCaseProgressDTO> setCaseProgress(List<MediationCaseProgressDTO> lst, CaseProgressEnum enumX, CaseProgressEnum enumY, int order, Boolean hiddenFlag) {
        Boolean flag = false;
        if (enumY != null) {
            flag = enumX.name().equals(enumY.name());
        }
        MediationCaseProgressDTO caseProgressDTO = new MediationCaseProgressDTO(enumX.name(), enumX.getName(), hiddenFlag != false && flag != false ? false : hiddenFlag, flag, order);
        lst.add(caseProgressDTO);
        return lst;
    }

    public static Boolean checkProgress(List<CaseProgressEnum> list, String value, String operate) {
        Boolean result = false;
        for (CaseProgressEnum caseProgressEnum : list) {
            if ("and".equals(operate) && !caseProgressEnum.name().equals(value)) {
                return false;
            }
            if (!"or".equals(operate) || !caseProgressEnum.name().equals(value)) continue;
            return true;
        }
        if ("and".equals(operate)) {
            result = true;
        }
        return result;
    }

    public static String getCodeName(String code) {
        String codeName = "\u672a\u77e5";
        try {
            codeName = CaseProgressEnum.valueOf(code).getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return codeName;
    }
}

